/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.world;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;

public class GeneratedFlower {
    public WorldGenerator generation;
    public int amount;
    public Biome[] biomes;
    public boolean isEnabled;
    public String description;

    public GeneratedFlower(String desc, WorldGenerator generation, int amount, Biome ... biomes) {
        this.generation = generation;
        this.amount = amount;
        this.biomes = biomes;
        this.isEnabled = true;
        this.description = desc;
    }

    public void runGeneration(World world, Random rand, int blockX, int blockZ) {
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(blockX, 64, blockZ));
        if (this.isEnabled()) {
            for (Biome b : this.biomes) {
                if (b != biome) continue;
                for (int i = 0; i < this.amount; ++i) {
                    int randX = blockX + rand.nextInt(16);
                    int randZ = blockZ + rand.nextInt(16);
                    this.generation.func_180709_b(world, rand, new BlockPos(randX + 8, 24, randZ + 8));
                }
            }
        }
    }

    public WorldGenerator getGeneration() {
        return this.generation;
    }

    public void setGeneration(WorldGenerator generation) {
        this.generation = generation;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public Biome[] getBiomes() {
        return this.biomes;
    }

    public void setBiomes(Biome[] biomes) {
        this.biomes = biomes;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}

