/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.core.modules.type;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.zawamod.configuration.ZAWAModuleConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.AnimalModule;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.event.ZAWAFeedEvent;

public class HungerModule
extends AnimalModule<AbstractZawaLand> {
    private ZAWAModuleConfig.ModuleOption<Boolean> enabled = new ZAWAModuleConfig.ModuleOption<Boolean>(".Enabled", "Hunger", true).register();
    private ZAWAModuleConfig.ModuleOption<Integer> eatingCooldown = new ZAWAModuleConfig.ModuleOption<Integer>("Eating Cool-down", "Hunger", 40).register();
    private ZAWAModuleConfig.ModuleOption<Float> maxFood = new ZAWAModuleConfig.ModuleOption<Float>("Max Hunger", "Hunger", Float.valueOf(20.0f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> hungerDepreciation = new ZAWAModuleConfig.ModuleOption<Float>("Hunger Depreciation per tick", "Hunger", Float.valueOf(3.0E-4f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> healthGain = new ZAWAModuleConfig.ModuleOption<Float>("Health gain from feeding when full", "Hunger", Float.valueOf(1.0f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> isHungryThreshold = new ZAWAModuleConfig.ModuleOption<Float>("Animal hungry when hunger < max - n", "Hunger", Float.valueOf(0.3f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> lowHungerDamageStart = new ZAWAModuleConfig.ModuleOption<Float>("How low hunger has to be for damage", "Hunger", Float.valueOf(0.0f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> starvationDamage = new ZAWAModuleConfig.ModuleOption<Float>("Starvation damage per tick", "Hunger", Float.valueOf(0.1f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> defaultHungerGain = new ZAWAModuleConfig.ModuleOption<Float>("Hunger gain if item is not player edible", "Hunger", Float.valueOf(1.0f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> defaultSaturationGain = new ZAWAModuleConfig.ModuleOption<Float>("Saturation gain if item is not player edible", "Hunger", Float.valueOf(0.2f)).register();
    private ZAWAModuleConfig.ModuleOption<Float> maxSaturation = new ZAWAModuleConfig.ModuleOption<Float>("Max hunger saturation", "Hunger", Float.valueOf(8.0f)).register();
    public static final String EATING_COOLDOWN = "eatingCooldown";

    @Override
    public ZAWAModuleConfig.ModuleOption<Boolean> getEnabled() {
        return this.enabled;
    }

    @Override
    public void registerData(AbstractZawaLand entity) {
        super.registerData(entity);
        entity.func_184212_Q().func_187214_a(AbstractZawaLand.HUNGER, (Object)Float.valueOf(this.getMaxFood()));
        entity.func_184212_Q().func_187214_a(AbstractZawaLand.SATURATION, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void readData(AbstractZawaLand entity, NBTTagCompound tag) {
        super.readData(entity, tag);
        this.setHunger(entity, tag.func_74760_g("Hunger"));
        this.setSaturation(entity, tag.func_74760_g("Saturation"));
    }

    @Override
    public void writeData(AbstractZawaLand entity, NBTTagCompound tag) {
        super.writeData(entity, tag);
        tag.func_74776_a("Hunger", this.getHunger(entity));
        tag.func_74780_a("Saturation", (double)this.getSaturation(entity));
    }

    @Override
    public void entityConstructed(AbstractZawaLand entity) {
        super.entityConstructed(entity);
        entity.getAnimalInt().put(EATING_COOLDOWN, 0);
    }

    @Override
    public Boolean playerInteract(AbstractZawaLand entity, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isHungry(entity) && entity.isFoodItem(stack) && entity.func_70909_n()) {
            this.onFed(entity, player, stack);
            return false;
        }
        if (!this.isHungry(entity) && entity.func_70909_n() && entity.isFoodItem(stack) && entity.func_110143_aJ() < entity.func_110138_aP()) {
            entity.func_70606_j(entity.func_110143_aJ() + this.healthGain.getValue().floatValue());
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            entity.field_70170_p.func_72960_a((Entity)entity, (byte)31);
            return true;
        }
        return super.playerInteract(entity, player, hand);
    }

    public float getHunger(AbstractZawaLand entity) {
        return this.entityHasModule(entity) ? ((Float)entity.func_184212_Q().func_187225_a(AbstractZawaLand.HUNGER)).floatValue() : 0.0f;
    }

    public void setHunger(AbstractZawaLand entity, float value) {
        if (!this.entityHasModule(entity)) {
            return;
        }
        entity.func_184212_Q().func_187227_b(AbstractZawaLand.HUNGER, (Object)Float.valueOf(value));
    }

    public void setSaturation(AbstractZawaLand entity, float saturation) {
        if (!this.entityHasModule(entity)) {
            return;
        }
        entity.func_184212_Q().func_187227_b(AbstractZawaLand.SATURATION, (Object)Float.valueOf(saturation));
    }

    public float getSaturation(AbstractZawaLand entity) {
        return this.entityHasModule(entity) ? ((Float)entity.func_184212_Q().func_187225_a(AbstractZawaLand.SATURATION)).floatValue() : 0.0f;
    }

    public boolean isHungry(AbstractZawaLand entity) {
        return entity.func_70909_n() && this.getHunger(entity) < this.getMaxFood() - this.isHungryThreshold.getValue().floatValue();
    }

    public float getMaxFood() {
        return this.maxFood.getValue().floatValue();
    }

    @Override
    public void onLivingStatHandle(AbstractZawaLand entity) {
        super.onLivingStatHandle(entity);
        if (entity.func_70089_S()) {
            if (this.getSaturation(entity) <= 0.0f) {
                this.setHunger(entity, this.getHunger(entity) - this.hungerDepreciation.getValue().floatValue());
                this.setSaturation(entity, 0.0f);
            } else {
                this.setSaturation(entity, this.getSaturation(entity) - 0.0025f);
            }
        }
        if ((double)this.getHunger(entity) <= 3.0 && entity.field_70170_p.field_72995_K && entity.field_70173_aa % 15 == 0) {
            entity.playStarvingEffect();
        }
        if (this.getHunger(entity) <= this.lowHungerDamageStart.getValue().floatValue()) {
            if (entity.field_70173_aa % 20 == 0) {
                entity.func_70097_a(DamageSource.field_76366_f, this.starvationDamage.getValue().floatValue());
            }
            this.setHunger(entity, 0.0f);
        }
    }

    @Override
    public void onUpdate(AbstractZawaLand entity) {
        super.onUpdate(entity);
        int value = entity.getAnimalInt().get(EATING_COOLDOWN);
        if (value > 0) {
            entity.getAnimalInt().put(EATING_COOLDOWN, value - 1);
        }
    }

    public boolean onFed(AbstractZawaLand entity, @Nullable EntityPlayer player, ItemStack stack) {
        ZAWAFeedEvent event = new ZAWAFeedEvent(player, entity, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (entity.getAnimalInt().get(EATING_COOLDOWN) > 0) {
            return false;
        }
        entity.getAnimalInt().put(EATING_COOLDOWN, this.eatingCooldown.getValue());
        if (stack.func_190926_b()) {
            return false;
        }
        if (player != null && !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (this.isHungry(entity)) {
            float saturation;
            float nutrition = stack.func_77973_b() instanceof ItemFood ? (float)((ItemFood)stack.func_77973_b()).func_150905_g(stack) : this.defaultHungerGain.getValue().floatValue();
            float f = saturation = stack.func_77973_b() instanceof ItemFood ? ((ItemFood)stack.func_77973_b()).func_150906_h(stack) : this.defaultSaturationGain.getValue().floatValue();
            if (ModuleManager.ENRICHMENT.lowEnrichment(entity)) {
                if (nutrition >= 1.1f) {
                    nutrition -= 1.0f;
                }
                if (saturation >= 0.2f) {
                    nutrition -= 0.1f;
                }
            }
            this.setHunger(entity, this.getHunger(entity) + nutrition);
            this.setSaturation(entity, this.getSaturation(entity) + saturation);
            if (this.getHunger(entity) > this.getMaxFood()) {
                this.setHunger(entity, this.getMaxFood());
            }
            if (this.getSaturation(entity) > this.maxSaturation.getValue().floatValue()) {
                this.setSaturation(entity, this.maxSaturation.getValue().floatValue());
            }
            entity.field_70170_p.func_72960_a((Entity)entity, (byte)70);
            entity.setJustAte(true);
        } else if (stack.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)stack.func_77973_b();
            entity.func_70606_j(entity.func_110143_aJ() + (float)food.func_150905_g(stack));
            EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
            for (int i = 0; i < 7; ++i) {
                double d0 = entity.func_70681_au().nextGaussian() * 0.02;
                double d1 = entity.func_70681_au().nextGaussian() * 0.02;
                double d2 = entity.func_70681_au().nextGaussian() * 0.02;
                entity.field_70170_p.func_175688_a(enumparticletypes, entity.field_70165_t + (double)(entity.func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, entity.field_70163_u + 0.5 + (double)(entity.func_70681_au().nextFloat() * entity.field_70131_O), entity.field_70161_v + (double)(entity.func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, d0, d1, d2, new int[0]);
            }
        } else {
            entity.func_70606_j(entity.func_110143_aJ() + this.healthGain.getValue().floatValue());
            if (entity.field_70170_p.field_72995_K) {
                entity.playTameEffect();
            }
            EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
            for (int i = 0; i < 7; ++i) {
                double d0 = entity.func_70681_au().nextGaussian() * 0.02;
                double d1 = entity.func_70681_au().nextGaussian() * 0.02;
                double d2 = entity.func_70681_au().nextGaussian() * 0.02;
                entity.field_70170_p.func_175688_a(enumparticletypes, entity.field_70165_t + (double)(entity.func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, entity.field_70163_u + 0.5 + (double)(entity.func_70681_au().nextFloat() * entity.field_70131_O), entity.field_70161_v + (double)(entity.func_70681_au().nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        return true;
    }

    @Override
    public void onTame(AbstractZawaLand entity, EntityPlayer player) {
        super.onTame(entity, player);
        this.setHunger(entity, this.getMaxFood());
    }
}

