/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityCassowary;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderCassowary
extends RenderLivingZAWA<EntityCassowary>
implements IBabyModel<EntityCassowary> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderCassowary(RenderManager m) {
        super(m, (ModelBase)RenderConstants.CASSOWARY, 0.3f);
        RenderConstants.CASSOWARY.setAnimator(CassowaryAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityCassowary entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 2);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityCassowary entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        } else {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityCassowary entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.CASSOWARY_BABY.setAnimator(CassowaryAnimator::new);
        return RenderConstants.CASSOWARY_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityCassowary e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/cassowary/cassowary.png");
        CONTAINER.addResource("textures/entity/cassowary/cassowary_2.png");
        CONTAINER.addResource("baby", "textures/entity/cassowary/cassowary_baby.png");
        CONTAINER.addResource("blink", "textures/entity/cassowary/cassowary_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/cassowary/cassowary_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/cassowary/cassowary_blink_baby.png");
    }

    public static class CassowaryAnimator
    extends ZAWAAnimator<EntityCassowary> {
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("ThighLeft");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartByName("LegLeft");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartByName("ThighRight");
        private final BookwormModelRenderer LegRight = this.getModel().getPartByName("LegRight");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartByName("FootLeft");
        private final BookwormModelRenderer FootRight = this.getModel().getPartByName("FootRight");
        private final BookwormModelRenderer Chest = this.getModel().getPartByName("Chest");
        private final BookwormModelRenderer Neck1 = this.getModel().getPartByName("Neck1");
        private final BookwormModelRenderer Neck2 = this.getModel().getPartByName("Neck2");
        private final BookwormModelRenderer Body2 = this.getModel().getPartByName("Body2");
        private final BookwormModelRenderer Tail1 = this.getModel().getPartByName("Tail1");

        public CassowaryAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityCassowary entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            EntityCassowary c = entity;
            this.Neck1.field_78795_f = f4 / 57.295776f + (c.func_70631_g_() ? -0.5f : -0.8f);
            this.speed = 6.1f;
            this.degree = 0.3f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.12f + (float)Math.PI)) * (this.degree * 4.0f) * f1 * 0.5f + 0.5f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(15.0f + f * this.speed * 0.12f + (float)Math.PI)) * (this.degree * 2.5f) * f1 * 0.5f + -0.8f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.12f + (float)Math.PI)) * (this.degree * -4.0f) * f1 * 0.5f + 0.5f;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(15.0f + f * this.speed * 0.12f + (float)Math.PI)) * (this.degree * -2.5f) * f1 * 0.5f + -0.8f;
            this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(15.0f + f * this.speed * 0.12f + (float)Math.PI)) * (this.degree * -1.5f) * f1 * 0.5f + 0.2f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(15.0f + f * this.speed * 0.12f + (float)Math.PI)) * (this.degree * 1.5f) * f1 * 0.5f + 0.2f;
            this.Chest.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.24f + (float)Math.PI)) * (this.degree * -0.3f) * f1 * 0.5f + -0.9f;
            this.Neck1.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.24f + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f + (c.func_70631_g_() ? -0.5f : -0.8f);
            this.Neck2.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.24f + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f + (c.func_70631_g_() ? -0.3f : -0.45f);
            this.Body2.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.24f + (float)Math.PI)) * (this.degree * 0.07f) * f1 * 0.5f + 0.4f;
            this.Tail1.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f + (float)Math.PI)) * (this.degree * 0.08f) * f1 * 0.5f + -0.5f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityCassowary entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 0.4f;
            EntityCassowary c = entity;
            this.Neck1.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.24f + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f + (c.func_70631_g_() ? -0.5f : -0.8f);
            this.Neck2.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.24f + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f + (c.func_70631_g_() ? -0.3f : -0.45f);
        }
    }
}

