/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityAmericanBison;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderAmericanBison
extends RenderLivingZAWA<EntityAmericanBison>
implements IBabyModel<EntityAmericanBison> {
    public static final ResourceLocation BLINK4 = new ResourceLocation("zawa:textures/entity/american_bison/bison_blink_4.png");
    public static final ResourceLocation BLINK = new ResourceLocation("zawa:textures/entity/american_bison/bison_blink_123.png");
    public static final ResourceLocation BLINKBABY = new ResourceLocation("zawa:textures/entity/american_bison/bison_blink_baby_1.png");
    public static final ResourceLocation BLINKBABY2 = new ResourceLocation("zawa:textures/entity/american_bison/bison_blink_baby_2.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderAmericanBison(RenderManager m) {
        super(m, (ModelBase)RenderConstants.BISON, 0.7f);
        RenderConstants.BISON.setRig(new CMFRig(RenderConstants.BISON, new ResourceLocation("zawa", "models/entity/american_bison/american_bison.rig")));
        RenderConstants.BISON.setAnimator(model -> new RenderBengalTiger.TigerAnimator((ModelCMF)model, 0.24f, 0.2f));
        RenderConstants.BISON_BABY.setRig(new CMFRig(RenderConstants.BISON_BABY, new ResourceLocation("zawa", "models/entity/american_bison/american_bison.rig")));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    protected ResourceLocation getEntityTexture(EntityAmericanBison animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityAmericanBison entity) {
        if (entity.func_70631_g_()) {
            return ModuleManager.VARIANT.getVariant(entity) == 3 ? BLINKBABY2 : BLINKBABY;
        }
        return ModuleManager.VARIANT.getVariant(entity) == 3 ? BLINK4 : BLINK;
    }

    @Override
    protected void preRenderCallback(EntityAmericanBison entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.0f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.4f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityAmericanBison e) {
        return CONTAINER.get(ModuleManager.VARIANT.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.BISON_BABY.setRig(new CMFRig(RenderConstants.BISON_BABY, new ResourceLocation("zawa", "models/entity/american_bison/american_bison.rig")));
        RenderConstants.BISON_BABY.setAnimator(BisonBabyAnimator::new);
        return RenderConstants.BISON_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityAmericanBison e) {
        return ModuleManager.VARIANT.getVariant(e) == 3 ? CONTAINER.get("baby", 1) : CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/american_bison/american_bison_1.png");
        CONTAINER.addResource("textures/entity/american_bison/american_bison_2.png");
        CONTAINER.addResource("textures/entity/american_bison/american_bison_3.png");
        CONTAINER.addResource("textures/entity/american_bison/american_bison_4.png");
        CONTAINER.addResource("baby", "textures/entity/american_bison/american_bison_baby_1.png");
        CONTAINER.addResource("baby", "textures/entity/american_bison/american_bison_baby_2.png");
    }

    public static class BisonBabyAnimator
    extends ZAWAAnimator<EntityAmericanBison> {
        private final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        private final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        private final BookwormModelRenderer tail2 = this.getModel().getPartFromRig("Tail2");
        private final BookwormModelRenderer tail1 = this.getModel().getPartFromRig("Tail1");
        private final BookwormModelRenderer mouth = this.getModel().getPartFromRig("Mouth");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartFromRig("ArmBaseRight");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("ArmRight");
        private final BookwormModelRenderer HandRight = this.getModel().getPartFromRig("HandRight");
        private final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartFromRig("ArmBaseLeft");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("ArmLeft");
        private final BookwormModelRenderer HandLeft = this.getModel().getPartFromRig("HandLeft");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("ThighRight");
        private final BookwormModelRenderer UpperLegRight = this.getModel().getPartFromRig("UpperLegRight");
        private final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("LegRight");
        private final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("ThighLeft");
        private final BookwormModelRenderer UpperLegLeft = this.getModel().getPartFromRig("UpperLegLeft");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("LegLeft");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");

        public BisonBabyAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAmericanBison entity) {
            this.jaw_part = this.mouth;
            this.neck_part = this.neck;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.neck.field_78795_f = f4 / 57.295776f - 0.2f;
            this.neck.field_78796_g = f3 / 57.295776f;
            if (this.neck.field_78796_g > 0.5f) {
                this.neck.field_78796_g = 0.5f;
            } else if (this.neck.field_78796_g < -0.5f) {
                this.neck.field_78796_g = -0.5f;
            }
            this.degree = 0.6f;
            this.speed = 2.6f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f;
            this.tail2.field_78808_h = MathHelper.func_76134_b((float)(21.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.9f) * f1 * 0.5f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.0f;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.2f;
            this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f + 0.1f - 0.0f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ArmBaseLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
            this.ArmBaseLeft.field_78795_f = -MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f + 0.1f - 0.0f;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
            this.HandLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f + 0.7f;
            this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.9f;
            this.LegRight.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 0.9f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ThighLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
            this.ThighLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f + 0.7f;
            this.UpperLegLeft.field_78795_f = -MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.9f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 0.9f;
            this.FootLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            if (!ZAWAUtils.isEntityMoving((Entity)entity) && ZAWAConfig.clientOptions.livingAnimations) {
                f = entity.field_70173_aa;
                f1 = 0.1f;
                this.degree = 1.0f;
                this.speed = 1.0f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.0f;
            }
        }
    }
}

