/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.world.worldgen;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.valkyrienskies.addon.world.ValkyrienSkiesWorld;
import org.valkyrienskies.addon.world.config.VSWorldConfig;
import org.valkyrienskies.addons.world.deps.kotlin.Metadata;
import org.valkyrienskies.addons.world.deps.kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.addons.world.deps.org.jetbrains.annotations.NotNull;
import org.valkyrienskies.addons.world.deps.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JJ\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/addon/world/worldgen/ValkyrienSkiesWorldGen;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "()V", "genValkyriumOre", "Lnet/minecraft/world/gen/feature/WorldGenMinable;", "getGenValkyriumOre", "()Lnet/minecraft/world/gen/feature/WorldGenMinable;", "setGenValkyriumOre", "(Lnet/minecraft/world/gen/feature/WorldGenMinable;)V", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "runValkyriumGenerator", "generator", "Lnet/minecraft/world/gen/feature/WorldGenerator;", "rand", "chunk_X", "chunk_Z", "chancesToSpawn", "minHeight", "maxHeight", "vs-world"})
public final class ValkyrienSkiesWorldGen
implements IWorldGenerator {
    @Nullable
    private WorldGenMinable genValkyriumOre;

    @Nullable
    public final WorldGenMinable getGenValkyriumOre() {
        return this.genValkyriumOre;
    }

    public final void setGenValkyriumOre(@Nullable WorldGenMinable worldGenMinable) {
        this.genValkyriumOre = worldGenMinable;
    }

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull(random, "random");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(chunkGenerator, "chunkGenerator");
        Intrinsics.checkParameterIsNotNull(chunkProvider, "chunkProvider");
        if (VSWorldConfig.valkyriumOreGenEnabled) {
            if (this.genValkyriumOre == null) {
                this.genValkyriumOre = new WorldGenMinable(ValkyrienSkiesWorld.Companion.getINSTANCE().getValkyriumOre().func_176223_P(), 8);
            }
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
            switch (worldProvider.getDimension()) {
                case 0: {
                    this.runValkyriumGenerator((WorldGenerator)this.genValkyriumOre, world, random, chunkX, chunkZ, 2, 0, 25);
                    break;
                }
                case -1: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runValkyriumGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        boolean bl = minHeight >= 0 && maxHeight <= 256 && minHeight <= maxHeight;
        int n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "Illegal Height Arguments for WorldGenerator";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int heightDiff = maxHeight - minHeight + 1;
        n = 0;
        n2 = chancesToSpawn;
        while (n < n2) {
            void i;
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            WorldGenerator worldGenerator = generator;
            if (worldGenerator == null) {
                Intrinsics.throwNpe();
            }
            worldGenerator.func_180709_b(world, rand, new BlockPos(x, y, z));
            ++i;
        }
    }
}

