/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.world.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.valkyrienskies.addon.world.ItemValkyriumCrystal;
import org.valkyrienskies.addon.world.PotionInit;
import org.valkyrienskies.addon.world.ValkyrienSkiesWorld;
import org.valkyrienskies.addon.world.block.BlockValkyriumOre;
import org.valkyrienskies.addon.world.capability.ICapabilityAntiGravity;
import org.valkyrienskies.addon.world.config.VSWorldConfig;
import org.valkyrienskies.addons.world.deps.kotlin.Metadata;
import org.valkyrienskies.addons.world.deps.kotlin.TypeCastException;
import org.valkyrienskies.addons.world.deps.kotlin.jvm.internal.DefaultConstructorMarker;
import org.valkyrienskies.addons.world.deps.kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.addons.world.deps.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/valkyrienskies/addon/world/util/LevitationUtil;", "", "()V", "Companion", "vs-world"})
public final class LevitationUtil {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/addon/world/util/LevitationUtil$Companion;", "", "()V", "addEntityLevitationEffects", "", "world", "Lnet/minecraft/world/World;", "vs-world"})
    public static final class Companion {
        public final void addEntityLevitationEffects(@NotNull World world) {
            Intrinsics.checkParameterIsNotNull(world, "world");
            for (Entity entity : world.field_72996_f) {
                if (entity instanceof EntityItem) {
                    ItemStack itemStack = ((EntityItem)entity).func_92059_d();
                    ICapabilityAntiGravity capability = (ICapabilityAntiGravity)itemStack.getCapability(ValkyrienSkiesWorld.Companion.getANTI_GRAVITY_CAPABILITY(), null);
                    if (capability == null) continue;
                    entity.func_70024_g(0.0, 0.08 * capability.getMultiplier(), 0.0);
                    continue;
                }
                if (!(entity instanceof EntityLivingBase)) continue;
                if (entity instanceof EntityPlayer && VSWorldConfig.valkyriumItemsLiftPlayers && !((EntityPlayer)entity).func_184812_l_()) {
                    double addedUpVelocity = 0.0;
                    for (NonNullList stackArray : ((EntityPlayer)entity).field_71071_by.field_184440_g) {
                        for (ItemStack stack : stackArray) {
                            if (stack == null) continue;
                            if (stack.func_77973_b() instanceof ItemBlock) {
                                Item item = stack.func_77973_b();
                                if (item == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.item.ItemBlock");
                                }
                                ItemBlock blockItem = (ItemBlock)item;
                                if (!(blockItem.func_179223_d() instanceof BlockValkyriumOre)) continue;
                                addedUpVelocity += 2.5E-4 * (double)stack.field_77994_a * VSWorldConfig.valkyriumOreForce;
                                continue;
                            }
                            if (!(stack.func_77973_b() instanceof ItemValkyriumCrystal)) continue;
                            addedUpVelocity += 2.5E-4 * (double)stack.field_77994_a * VSWorldConfig.valkyriumCrystalForce;
                        }
                    }
                    if (addedUpVelocity > 0.0) {
                        entity.func_70024_g(0.0, addedUpVelocity, 0.0);
                        if (addedUpVelocity > 0.05) {
                            entity.field_70143_R = 0.0f;
                        }
                    }
                }
                if (((EntityLivingBase)entity).func_70644_a((Potion)PotionInit.Companion.getLEVITATION_POTION_EFFECT())) {
                    PotionEffect levitationEffect = ((EntityLivingBase)entity).func_70660_b((Potion)PotionInit.Companion.getLEVITATION_POTION_EFFECT());
                    if (entity instanceof EntityPlayer && (((EntityPlayer)entity).func_184812_l_() || ((EntityPlayer)entity).func_175149_v())) break;
                    PotionEffect potionEffect = levitationEffect;
                    if (potionEffect == null) {
                        Intrinsics.throwNpe();
                    }
                    switch (potionEffect.func_76458_c()) {
                        case 0: {
                            entity.func_70024_g(0.0, 0.07, 0.0);
                            break;
                        }
                        case 1: {
                            entity.func_70024_g(0.0, 0.1, 0.0);
                            break;
                        }
                    }
                    entity.field_70143_R = 0.0f;
                }
                if (!((EntityLivingBase)entity).func_70644_a((Potion)PotionInit.Companion.getLEVITATION_JUMP_POTION_EFFECT())) continue;
                PotionEffect levitationEffect = ((EntityLivingBase)entity).func_70660_b((Potion)PotionInit.Companion.getLEVITATION_JUMP_POTION_EFFECT());
                if (entity instanceof EntityPlayer && (((EntityPlayer)entity).func_184812_l_() || ((EntityPlayer)entity).func_175149_v())) break;
                PotionEffect potionEffect = levitationEffect;
                if (potionEffect == null) {
                    Intrinsics.throwNpe();
                }
                if ((double)potionEffect.func_76459_b() > 108.0) {
                    entity.func_70024_g(0.0, 0.2, 0.0);
                } else {
                    entity.func_70024_g(0.0, 0.05, 0.0);
                }
                entity.field_70143_R = 0.0f;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

