/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.world;

import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.valkyrienskies.addon.world.ItemValkyriumCrystal;
import org.valkyrienskies.addon.world.block.BlockValkyriumOre;
import org.valkyrienskies.addon.world.capability.AntiGravityCapabilityProvider;
import org.valkyrienskies.addon.world.util.LevitationUtil;
import org.valkyrienskies.addons.world.deps.kotlin.Metadata;
import org.valkyrienskies.addons.world.deps.kotlin.TypeCastException;
import org.valkyrienskies.addons.world.deps.kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.addons.world.deps.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/addon/world/WorldEventsCommon;", "", "()V", "onAttachCapabilityEventItem", "", "event", "Lnet/minecraftforge/event/AttachCapabilitiesEvent;", "Lnet/minecraft/item/ItemStack;", "worldTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;", "vs-world"})
public final class WorldEventsCommon {
    @SubscribeEvent
    public final void onAttachCapabilityEventItem(@NotNull AttachCapabilitiesEvent<ItemStack> event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        Object object = event.getObject();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.item.ItemStack");
        }
        ItemStack stack = (ItemStack)object;
        Item item = stack.func_77973_b();
        if (item instanceof ItemValkyriumCrystal) {
            event.addCapability(new ResourceLocation("vs_world", "levitation_strength_capability"), (ICapabilityProvider)new AntiGravityCapabilityProvider(1.0));
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            Item item2 = stack.func_77973_b();
            if (item2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.item.ItemBlock");
            }
            ItemBlock blockItem = (ItemBlock)item2;
            if (blockItem.func_179223_d() instanceof BlockValkyriumOre) {
                event.addCapability(new ResourceLocation("vs_world", "levitation_strength_capability"), (ICapabilityProvider)new AntiGravityCapabilityProvider(1.0));
            }
        }
    }

    @SubscribeEvent
    public final void worldTick(@NotNull TickEvent.WorldTickEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event.phase == TickEvent.Phase.START) {
            World world = event.world;
            Intrinsics.checkExpressionValueIsNotNull(world, "event.world");
            LevitationUtil.Companion.addEntityLevitationEffects(world);
        }
    }
}

