/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.nodenetwork.BasicForceNodeTileEntity;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;

public class TileEntityPropellerEngine
extends BasicForceNodeTileEntity {
    private double propellerAngle;
    private double prevPropellerAngle;
    private boolean isPowered;
    private double propellerAngularVelocity;

    public TileEntityPropellerEngine(Vector3dc normalVeclocityUnoriented, boolean isForceOutputOriented, double maxThrust) {
        super(normalVeclocityUnoriented, isForceOutputOriented, maxThrust);
        this.isPowered = false;
        this.prevPropellerAngle = this.propellerAngle = Math.random() * 90.0;
        this.propellerAngularVelocity = 0.0;
    }

    public TileEntityPropellerEngine() {
        this.prevPropellerAngle = this.propellerAngle = Math.random() * 90.0;
    }

    public double getPropellerAngle(double partialTicks) {
        double delta = this.propellerAngle - this.prevPropellerAngle;
        if (Math.abs(delta) > 180.0) {
            delta %= 180.0;
            delta += 180.0;
        }
        return this.prevPropellerAngle + delta * partialTicks;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.isPowered = this.field_145850_b.func_175640_z(this.func_174877_v());
        if (this.isPowered) {
            this.propellerAngularVelocity += 1.0;
        } else {
            this.propellerAngularVelocity *= Math.max(Math.random(), 0.9) * 1.05;
            this.propellerAngularVelocity -= 0.75 * Math.random() * Math.random();
        }
        this.propellerAngularVelocity = Math.max(0.0, Math.min(this.propellerAngularVelocity, 50.0));
        this.prevPropellerAngle = this.propellerAngle;
        this.propellerAngle += this.propellerAngularVelocity;
        this.propellerAngle %= 360.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.propellerAngularVelocity = compound.func_74769_h("propellerAngularVelocity");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74780_a("propellerAngularVelocity", this.propellerAngularVelocity);
        return super.func_189515_b(compound);
    }

    @Override
    public double getThrustMagnitude(PhysicsObject physicsObject) {
        try {
            IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (blockState.func_177230_c() == ValkyrienSkiesControl.INSTANCE.vsControlBlocks.redstoneEngine) {
                int redstonePower = this.func_145831_w().func_175687_A(this.func_174877_v());
                return (double)redstonePower * this.getMaxThrust() * this.getThrustMultiplierGoal();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.getMaxThrust() * this.getThrustMultiplierGoal();
    }
}

