/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl;

import java.util.ArrayList;
import java.util.List;

public class BasicKeyframeInterpolator {
    private final List<KeyFrame> knownFrames = new ArrayList<KeyFrame>();

    public BasicKeyframeInterpolator(List<String[]> keyframes) {
        for (String[] frame : keyframes) {
            KeyFrame framePair = new KeyFrame(Double.valueOf(frame[0]), Double.valueOf(frame[1]));
            this.knownFrames.add(framePair);
        }
    }

    public double getValue(double keyframe) {
        if (this.knownFrames.size() == 1) {
            return this.knownFrames.get(0).getValue();
        }
        if (keyframe <= this.knownFrames.get((int)0).keyframe) {
            return this.knownFrames.get(0).getValue();
        }
        if (keyframe >= this.knownFrames.get((int)(this.knownFrames.size() - 1)).keyframe) {
            return this.knownFrames.get(this.knownFrames.size() - 1).getValue();
        }
        for (int i = 0; i < this.knownFrames.size(); ++i) {
            double currentKeyframe = this.knownFrames.get(i).getKey();
            if (currentKeyframe == keyframe) {
                return this.knownFrames.get(i).getValue();
            }
            if (!(currentKeyframe > keyframe)) continue;
            double lastKeyFrame = this.knownFrames.get(i - 1).getKey();
            double currentKeyFrameValue = this.knownFrames.get(i).getValue();
            double lastKeyFrameValue = this.knownFrames.get(i - 1).getValue();
            double frameDelta = (keyframe - lastKeyFrame) / (currentKeyframe - lastKeyFrame);
            return lastKeyFrameValue + (currentKeyFrameValue - lastKeyFrameValue) * frameDelta;
        }
        return 0.0;
    }

    private static class KeyFrame {
        final double keyframe;
        final double value;

        KeyFrame(double keyframe, double value) {
            this.keyframe = keyframe;
            this.value = value;
        }

        double getKey() {
            return this.keyframe;
        }

        double getValue() {
            return this.value;
        }
    }
}

