/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.IAtomAnimation;
import org.valkyrienskies.addon.control.renderer.atom_animation_parser.impl.BasicDagNodeRenderer;

public class BasicAtomAnimation
implements IAtomAnimation {
    private List<BasicDagNodeRenderer> dagNodes;
    private double minKeyFrame;
    private double maxKeyFrame;

    public BasicAtomAnimation(List<BasicDagNodeRenderer> dagNodes, double minKeyFrame, double maxKeyFrame) {
        this.dagNodes = dagNodes;
        this.minKeyFrame = minKeyFrame;
        this.maxKeyFrame = maxKeyFrame;
    }

    @Override
    public void renderAnimation(double keyframe, int brightness) {
        if (keyframe < this.minKeyFrame || keyframe > this.maxKeyFrame) {
            // empty if block
        }
        for (BasicDagNodeRenderer dagNode : this.dagNodes) {
            GlStateManager.func_179094_E();
            dagNode.render(keyframe, brightness);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public double getMinKeyframe() {
        return this.minKeyFrame;
    }

    @Override
    public double getMaxKeyframe() {
        return this.maxKeyFrame;
    }

    @Override
    public void renderAnimationNode(String nodeName, double keyframe, int brightness) {
        for (BasicDagNodeRenderer dagNode : this.dagNodes) {
            if (!dagNode.getModelName().equals(nodeName)) continue;
            GlStateManager.func_179094_E();
            dagNode.render(keyframe, brightness);
            GlStateManager.func_179121_F();
        }
    }
}

