/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import org.valkyrienskies.addon.control.block.BlockGearbox;
import org.valkyrienskies.addon.control.renderer.GibsAtomAnimationRegistry;
import org.valkyrienskies.addon.control.tileentity.TileEntityGearbox;
import org.valkyrienskies.mod.client.render.GibsModelRegistry;

public class GearboxTileEntityRenderer
extends TileEntitySpecialRenderer<TileEntityGearbox> {
    private static final ImmutableMap<EnumFacing, String> FACING_TO_AXLE_NAME = ImmutableMap.builder().put((Object)EnumFacing.DOWN, (Object)"gearbox_top_geo").put((Object)EnumFacing.UP, (Object)"gearbox_bottom_geo").put((Object)EnumFacing.SOUTH, (Object)"gearbox_front_geo").put((Object)EnumFacing.NORTH, (Object)"gearbox_back_geo").put((Object)EnumFacing.WEST, (Object)"gearbox_right_geo").put((Object)EnumFacing.EAST, (Object)"gearbox_left_geo").build();

    public void render(TileEntityGearbox tileentity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        double rotationFrom0To360;
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        int brightness = tileentity.func_145831_w().func_175626_b(tileentity.func_174877_v(), 0);
        float renderRotation = (float)Math.toDegrees(tileentity.getRenderRotationRadians(partialTick));
        Optional<Double>[] connectedAngularVelocityRatios = tileentity.getConnectedSidesRatios();
        for (EnumFacing facing : EnumFacing.values()) {
            Optional<Double> ratio = connectedAngularVelocityRatios[facing.ordinal()];
            if (!ratio.isPresent()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            Vec3i facingVec = facing.func_176730_m();
            double effectiveRenderRotation = (double)renderRotation * ratio.get();
            GlStateManager.func_179114_b((float)((float)effectiveRenderRotation), (float)facingVec.func_177958_n(), (float)facingVec.func_177956_o(), (float)facingVec.func_177952_p());
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            GibsModelRegistry.renderGibsModel((String)((String)FACING_TO_AXLE_NAME.get((Object)facing)), (int)brightness);
            GlStateManager.func_179121_F();
        }
        IBlockState gearState = Minecraft.func_71410_x().field_71441_e.func_180495_p(tileentity.func_174877_v());
        if (gearState.func_177230_c() instanceof BlockGearbox) {
            EnumFacing facing = tileentity.getRenderFacing();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            switch (facing) {
                case UP: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case DOWN: {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case NORTH: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        }
        if ((rotationFrom0To360 = (double)(renderRotation % 360.0f)) < 0.0) {
            rotationFrom0To360 += 360.0;
        }
        double keyframe = rotationFrom0To360 * 99.0 / 360.0 + 1.0;
        GibsAtomAnimationRegistry.getAnimation("gearbox").renderAnimation(keyframe, brightness);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179117_G();
    }
}

