/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.nodenetwork;

import gigaherz.graph.api.Graph;
import gigaherz.graph.api.Mergeable;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.nodenetwork.IVSNode;
import org.valkyrienskies.addon.control.nodenetwork.IVSNodeProvider;
import org.valkyrienskies.addon.control.nodenetwork.VSNode_TileEntity;
import org.valkyrienskies.mod.common.ships.ShipData;

public abstract class BasicNodeTileEntity
extends TileEntity
implements IVSNodeProvider,
ITickable {
    private final VSNode_TileEntity tileNode = new VSNode_TileEntity(this, this.getMaximumConnections());
    private boolean firstUpdate = true;

    public SPacketUpdateTileEntity func_189518_D_() {
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.tileNode.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tileNode.readFromNBT(compound);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound toReturn = super.func_189517_E_();
        return this.func_189515_b(toReturn);
    }

    @Override
    public VSNode_TileEntity getNode() {
        return this.tileNode;
    }

    public void func_145843_s() {
        VSNode_TileEntity toInvalidate = this.getNode();
        Graph graph = toInvalidate.getGraph();
        if (graph != null) {
            graph.remove(toInvalidate);
            toInvalidate.breakAllConnections();
        }
        this.field_145846_f = true;
        toInvalidate.invalidate();
    }

    public void func_145829_t() {
        this.field_145846_f = false;
        this.getNode().validate();
    }

    public void func_73660_a() {
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.init();
        }
    }

    protected int getMaximumConnections() {
        return 1;
    }

    private void init() {
        if (this.tileNode.getGraph() == null) {
            return;
        }
        try {
            this.tileNode.getGraph().addNeighours(this.tileNode, this.tileNode.getNeighbours());
        }
        catch (Exception e) {
            System.err.println("Node TileEntity error at " + this.func_174877_v());
            e.printStackTrace();
        }
    }

    @Override
    public Iterable<IVSNode> getNetworkedConnections() {
        return () -> this.tileNode.getGraph().getObjects().iterator();
    }

    @Nullable
    public TileEntity createRelocatedTile(BlockPos newPos, @Nullable ShipData copiedBy) {
        NBTTagCompound tileEntNBT = this.func_189515_b(new NBTTagCompound());
        tileEntNBT.func_74768_a("x", newPos.func_177958_n());
        tileEntNBT.func_74768_a("y", newPos.func_177956_o());
        tileEntNBT.func_74768_a("z", newPos.func_177952_p());
        int[] oldData = tileEntNBT.func_74759_k("VSNode_Tile_Data");
        int[] newData = new int[oldData.length];
        for (int i = 0; i < oldData.length; i += 4) {
            newData[i] = oldData[i] + newPos.func_177958_n() - this.func_174877_v().func_177958_n();
            newData[i + 1] = oldData[i + 1] + newPos.func_177956_o() - this.func_174877_v().func_177956_o();
            newData[i + 2] = oldData[i + 2] + newPos.func_177952_p() - this.func_174877_v().func_177952_p();
            newData[i + 3] = oldData[i + 3];
        }
        tileEntNBT.func_74783_a("VSNode_Tile_Data", newData);
        try {
            return TileEntity.func_190200_a((World)this.field_145850_b, (NBTTagCompound)tileEntNBT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class GraphData
    implements Mergeable<GraphData> {
        private static volatile int sUid = 0;
        private final int uid;

        public GraphData() {
            this.uid = ++sUid;
        }

        public GraphData(int uid) {
            this.uid = uid;
        }

        @Override
        public GraphData mergeWith(GraphData other) {
            return new GraphData(this.uid + other.uid);
        }

        @Override
        public GraphData copy() {
            return new GraphData();
        }

        public int getUid() {
            return this.uid;
        }
    }
}

