/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.torque.custom_torque_functions;

import org.valkyrienskies.addon.control.block.torque.IRotationNode;
import org.valkyrienskies.addon.control.block.torque.custom_torque_functions.SimpleTorqueFunction;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;

public class ValkyriumEngineTorqueFunction
extends SimpleTorqueFunction {
    public static final double MAX_TORQUE = 10000.0;
    public static final double MAX_ROTATION_VELOCITY = Math.PI;
    public static final double SLOWDOWN_RATIO = 0.0;

    public ValkyriumEngineTorqueFunction(IRotationNode rotationNode) {
        super(rotationNode);
    }

    @Override
    public double calculateTorque(PhysicsObject object) {
        double currentRotVel = this.rotationNode.getAngularVelocity();
        if (currentRotVel < 0.0) {
            return 100.0;
        }
        if (currentRotVel > Math.PI) {
            return 0.0;
        }
        if (currentRotVel > 0.0) {
            double ratio = currentRotVel / Math.PI;
            double outputTorqueRatio = 1.0 - (ratio - 0.0) / 1.0;
            if (outputTorqueRatio < -0.99 || outputTorqueRatio > 1.01) {
                throw new IllegalStateException("Error calculating ether engine torque function");
            }
            return outputTorqueRatio * 10000.0;
        }
        return 10000.0;
    }
}

