/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.block.multiblocks.BlockPosBlockPair;
import org.valkyrienskies.addon.control.block.multiblocks.EnumMultiblockRotation;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityValkyriumCompressorPart;

public class ValkyriumCompressorMultiblockSchematic
implements IMultiblockSchematic {
    private final List<BlockPosBlockPair> structureRelativeToCenter = new ArrayList<BlockPosBlockPair>();
    private String schematicID = "unknown";
    private EnumMultiblockRotation multiblockRotation;

    @Override
    public void initializeMultiblockSchematic(String schematicID) {
        Block enginePart = ValkyrienSkiesControl.INSTANCE.vsControlBlocks.valkyriumCompressorPart;
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 1; ++z) {
                    this.structureRelativeToCenter.add(new BlockPosBlockPair(new BlockPos(x, y, z), enginePart));
                }
            }
        }
        this.schematicID = schematicID;
    }

    @Override
    public List<BlockPosBlockPair> getStructureRelativeToCenter() {
        return this.structureRelativeToCenter;
    }

    @Override
    public String getSchematicID() {
        return this.schematicID;
    }

    @Override
    public void applyMultiblockCreation(World world, BlockPos tilePos, BlockPos relativePos) {
        TileEntity tileEntity = world.func_175625_s(tilePos);
        if (!(tileEntity instanceof TileEntityValkyriumCompressorPart)) {
            throw new IllegalStateException();
        }
        TileEntityValkyriumCompressorPart enginePart = (TileEntityValkyriumCompressorPart)tileEntity;
        enginePart.assembleMultiblock(this, relativePos);
    }

    @Override
    public String getSchematicPrefix() {
        return "multiblock_valkyrium_compressor";
    }

    @Override
    public List<IMultiblockSchematic> generateAllVariants() {
        ArrayList<IMultiblockSchematic> varients = new ArrayList<IMultiblockSchematic>();
        for (EnumMultiblockRotation potentialRotation : EnumMultiblockRotation.values()) {
            ValkyriumCompressorMultiblockSchematic varient = new ValkyriumCompressorMultiblockSchematic();
            varient.initializeMultiblockSchematic(this.getSchematicPrefix() + ":rot:" + potentialRotation.toString());
            ArrayList<BlockPosBlockPair> rotatedPairs = new ArrayList<BlockPosBlockPair>();
            for (BlockPosBlockPair unrotatedPairs : varient.structureRelativeToCenter) {
                BlockPos rotatedPos = potentialRotation.rotatePos(unrotatedPairs.getPos());
                rotatedPairs.add(new BlockPosBlockPair(rotatedPos, unrotatedPairs.getBlock()));
            }
            varient.structureRelativeToCenter.clear();
            varient.structureRelativeToCenter.addAll(rotatedPairs);
            varient.multiblockRotation = potentialRotation;
            varients.add(varient);
        }
        return varients;
    }

    @Override
    public EnumMultiblockRotation getMultiblockRotation() {
        return this.multiblockRotation;
    }
}

