/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityMultiblockPartForce;
import org.valkyrienskies.addon.control.block.multiblocks.ValkyriumCompressorMultiblockSchematic;
import org.valkyrienskies.addon.control.fuel.IValkyriumEngine;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class TileEntityValkyriumCompressorPart
extends TileEntityMultiblockPartForce<ValkyriumCompressorMultiblockSchematic, TileEntityValkyriumCompressorPart>
implements IValkyriumEngine {
    private static final Vector3dc FORCE_NORMAL = new Vector3d(0.0, 1.0, 0.0);
    private double prevKeyframe;
    private double currentKeyframe;

    public TileEntityValkyriumCompressorPart() {
    }

    public TileEntityValkyriumCompressorPart(double maxThrust) {
        this();
        this.setMaxThrust(maxThrust);
        this.prevKeyframe = 0.0;
        this.currentKeyframe = 0.0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.prevKeyframe = this.currentKeyframe;
        this.currentKeyframe += 1.2;
        this.currentKeyframe %= 99.0;
    }

    @Override
    public Vector3dc getForceOutputNormal(double secondsToApply, PhysicsObject object) {
        return FORCE_NORMAL;
    }

    @Override
    public void setThrustMultiplierGoal(double thrustMultiplierGoal) {
        if (this.isMaster() || this.getMaster() == this) {
            super.setThrustMultiplierGoal(thrustMultiplierGoal);
        } else {
            ((TileEntityValkyriumCompressorPart)this.getMaster()).setThrustMultiplierGoal(thrustMultiplierGoal);
        }
    }

    @Override
    public double getThrustMagnitude(PhysicsObject physicsObject) {
        if (this.isPartOfAssembledMultiblock() && this.getMaster() instanceof TileEntityValkyriumCompressorPart) {
            return this.getMaxThrust() * ((TileEntityValkyriumCompressorPart)this.getMaster()).getThrustMultiplierGoal() * this.getCurrentValkyriumEfficiency(physicsObject);
        }
        return 0.0;
    }

    @Override
    public double getCurrentValkyriumEfficiency(@Nonnull PhysicsObject physicsObject) {
        Vector3d tilePos = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        physicsObject.getShipTransformationManager().getCurrentPhysicsTransform().transformPosition(tilePos, TransformType.SUBSPACE_TO_GLOBAL);
        double yPos = tilePos.y;
        return IValkyriumEngine.getValkyriumEfficiencyFromHeight(yPos);
    }

    public double getCurrentKeyframe(double partialTick) {
        double increment = this.currentKeyframe - this.prevKeyframe;
        if (increment < 0.0) {
            increment = increment % 99.0 + 99.0;
        }
        return this.prevKeyframe + increment * partialTick + 1.0;
    }

    @Override
    public boolean attemptToAssembleMultiblock(World worldIn, BlockPos pos, EnumFacing facing) {
        List<IMultiblockSchematic> valkyriumEngineMultiblockSchematics = MultiblockRegistry.getSchematicsWithPrefix("multiblock_valkyrium_compressor");
        for (IMultiblockSchematic schematic : valkyriumEngineMultiblockSchematics) {
            if (!schematic.attemptToCreateMultiblock(worldIn, pos)) continue;
            return true;
        }
        return false;
    }
}

