/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.GiantPropellerMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityMultiblockPartForce;
import org.valkyrienskies.addon.control.block.torque.IRotationNode;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeProvider;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorld;
import org.valkyrienskies.addon.control.block.torque.ImplRotationNode;
import org.valkyrienskies.addon.control.util.ValkyrienSkiesControlUtil;
import org.valkyrienskies.mod.common.network.VSNetwork;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class TileEntityGiantPropellerPart
extends TileEntityMultiblockPartForce<GiantPropellerMultiblockSchematic, TileEntityGiantPropellerPart>
implements IRotationNodeProvider<TileEntityGiantPropellerPart> {
    public static final int GIANT_PROPELLER_SORTING_PRIORITY = 50;
    private final IRotationNode rotationNode = new ImplRotationNode<TileEntityGiantPropellerPart>(this, 5.0, 50);
    private double prevPropellerAngle;
    private double propellerAngle;
    private double nextPropellerAngle;
    private boolean firstUpdate = true;

    @Override
    public double getMaxThrust() {
        return 999999.0;
    }

    @Override
    public Vector3dc getForceOutputNormal(double secondsToApply, PhysicsObject physicsObject) {
        if (!this.isPartOfAssembledMultiblock()) {
            return null;
        }
        if (!this.isMaster()) {
            TileEntityGiantPropellerPart master = (TileEntityGiantPropellerPart)this.getMaster();
            if (master != null) {
                return master.getForceOutputNormal(secondsToApply, physicsObject);
            }
            return null;
        }
        if (!this.getRotationNode().isPresent()) {
            return null;
        }
        if (this.getRotationNode().get().getAngularVelocity() == 0.0) {
            return null;
        }
        Vector3d facingDir = JOML.convertTo3d((Vec3i)this.getPropellerFacing().func_176730_m());
        double angularVelocity = this.getRotationNode().get().getAngularVelocity();
        if (angularVelocity != 0.0) {
            facingDir.mul(-Math.signum(angularVelocity));
        }
        return facingDir;
    }

    @Override
    public double getThrustMagnitude(PhysicsObject physicsObject) {
        if (!this.isPartOfAssembledMultiblock()) {
            return 0.0;
        }
        if (!this.isMaster()) {
            TileEntityGiantPropellerPart master = (TileEntityGiantPropellerPart)this.getMaster();
            if (master != null) {
                return master.getThrustMagnitude(physicsObject);
            }
            return 0.0;
        }
        if (!this.getRotationNode().isPresent()) {
            return 0.0;
        }
        double angularVel = this.getRotationNode().get().getAngularVelocity();
        return 500.0 * angularVel * angularVel;
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.firstUpdate) {
                this.rotationNode.markInitialized();
                this.rotationNode.queueTask(() -> this.rotationNode.setAngularVelocityRatio(((GiantPropellerMultiblockSchematic)this.getMultiBlockSchematic()).getPropellerFacing().func_176734_d(), Optional.of(-1.0)));
                this.firstUpdate = false;
            }
            if (this.isPartOfAssembledMultiblock()) {
                Optional physicsObjectOptional = ValkyrienUtils.getPhysoManagingBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
                if (this.isMaster()) {
                    if (!this.rotationNode.hasBeenPlacedIntoNodeWorld()) {
                        IRotationNodeWorld nodeWorld = physicsObjectOptional.isPresent() ? ValkyrienSkiesControlUtil.getRotationWorldFromShip((PhysicsObject)physicsObjectOptional.get()) : ValkyrienSkiesControlUtil.getRotationWorldFromWorld(this.func_145831_w());
                        nodeWorld.enqueueTaskOntoWorld(() -> nodeWorld.setNodeFromPos(this.func_174877_v(), this.rotationNode));
                        int propellerRadius = ((GiantPropellerMultiblockSchematic)this.getMultiBlockSchematic()).getPropellerRadius();
                        this.rotationNode.queueTask(() -> this.rotationNode.setRotationalInertia(propellerRadius * propellerRadius));
                    }
                    this.prevPropellerAngle = this.propellerAngle;
                    this.propellerAngle = Math.toDegrees(this.rotationNode.getAngularRotationUnsynchronized());
                }
                VSNetwork.sendTileToAllNearby((TileEntity)this);
            }
        } else {
            this.prevPropellerAngle = this.propellerAngle;
            double increment = this.nextPropellerAngle - this.propellerAngle;
            if (increment < 0.0) {
                increment = MathHelper.func_76138_g((double)increment);
            }
            this.propellerAngle += increment * 0.75;
        }
    }

    @Override
    public boolean attemptToAssembleMultiblock(World worldIn, BlockPos pos, EnumFacing facing) {
        List<IMultiblockSchematic> schematics = MultiblockRegistry.getSchematicsWithPrefix("multiblock_giant_propeller");
        for (IMultiblockSchematic schematic : schematics) {
            GiantPropellerMultiblockSchematic propSchem = (GiantPropellerMultiblockSchematic)schematic;
            if (propSchem.getPropellerFacing() != facing || !schematic.attemptToCreateMultiblock(worldIn, pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disassembleMultiblockLocal() {
        super.disassembleMultiblockLocal();
        Optional object = ValkyrienUtils.getPhysoManagingBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        object.ifPresent(obj -> this.rotationNode.queueTask(this.rotationNode::resetNodeData));
    }

    @Override
    public Optional<IRotationNode> getRotationNode() {
        if (this.rotationNode.isInitialized()) {
            return Optional.of(this.rotationNode);
        }
        return Optional.empty();
    }

    public EnumFacing getPropellerFacing() {
        if (!this.isPartOfAssembledMultiblock()) {
            return null;
        }
        return ((GiantPropellerMultiblockSchematic)this.getMultiBlockSchematic()).getPropellerFacing();
    }

    public int getPropellerRadius() {
        if (!this.isPartOfAssembledMultiblock()) {
            return 1;
        }
        return ((GiantPropellerMultiblockSchematic)this.getMultiBlockSchematic()).getPropellerRadius();
    }

    public float getPropellerAngle(float partialTick) {
        return (float)(this.prevPropellerAngle + (this.propellerAngle - this.prevPropellerAngle) * (double)partialTick);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rotationNode.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.rotationNode.writeToNBT(compound);
        return compound;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound toSend = super.func_189515_b(new NBTTagCompound());
        toSend.func_74780_a("propeller_angle", this.propellerAngle);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, toSend);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.nextPropellerAngle = pkt.func_148857_g().func_74769_h("propeller_angle");
    }
}

