/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.block.multiblocks.BlockPosBlockPair;
import org.valkyrienskies.addon.control.block.multiblocks.EnumMultiblockRotation;
import org.valkyrienskies.addon.control.block.multiblocks.ITileEntityMultiblockPart;

public interface IMultiblockSchematic {
    public void initializeMultiblockSchematic(String var1);

    public List<BlockPosBlockPair> getStructureRelativeToCenter();

    default public AxisAlignedBB getSchematicRenderBB(BlockPos masterPos) {
        double minZ = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minX = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        for (BlockPosBlockPair pair : this.getStructureRelativeToCenter()) {
            double curX = pair.getPos().func_177958_n() + masterPos.func_177958_n();
            double curY = pair.getPos().func_177956_o() + masterPos.func_177956_o();
            double curZ = pair.getPos().func_177952_p() + masterPos.func_177952_p();
            minX = Math.min(curX, minX);
            minY = Math.min(curY, minY);
            minZ = Math.min(curZ, minZ);
            maxX = Math.max(curX, maxX);
            maxY = Math.max(curY, maxY);
            maxZ = Math.max(curZ, maxZ);
        }
        return new AxisAlignedBB(minX - 0.5, minY - 0.5, minZ - 0.5, maxX + 0.5, maxY + 0.5, maxZ + 0.5);
    }

    public String getSchematicPrefix();

    public String getSchematicID();

    default public boolean attemptToCreateMultiblock(World world, BlockPos pos) {
        BlockPos realPos;
        if (this.getStructureRelativeToCenter().size() == 0) {
            throw new IllegalStateException("No structure info found in the multiblock schematic!");
        }
        boolean buildSuccessful = true;
        for (BlockPosBlockPair pair : this.getStructureRelativeToCenter()) {
            realPos = pos.func_177971_a((Vec3i)pair.getPos());
            IBlockState state = world.func_180495_p(realPos);
            if (state.func_177230_c() != pair.getBlock()) {
                buildSuccessful = false;
                break;
            }
            TileEntity tile = world.func_175625_s(realPos);
            if (tile instanceof ITileEntityMultiblockPart) {
                ITileEntityMultiblockPart multiblockPart = (ITileEntityMultiblockPart)tile;
                if (!multiblockPart.isPartOfAssembledMultiblock()) continue;
                buildSuccessful = false;
                break;
            }
            buildSuccessful = false;
            break;
        }
        if (buildSuccessful) {
            for (BlockPosBlockPair pair : this.getStructureRelativeToCenter()) {
                realPos = pos.func_177971_a((Vec3i)pair.getPos());
                this.applyMultiblockCreation(world, realPos, pair.getPos());
            }
            return true;
        }
        return false;
    }

    public void applyMultiblockCreation(World var1, BlockPos var2, BlockPos var3);

    public List<IMultiblockSchematic> generateAllVariants();

    default public EnumMultiblockRotation getMultiblockRotation() {
        return EnumMultiblockRotation.NONE;
    }
}

