/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.renderer.infuser_core_rendering.InfuserCoreBakedModel;
import org.valkyrienskies.mod.common.piloting.IShipPilot;
import org.valkyrienskies.mod.common.piloting.ITileEntityPilotable;

public class ControlEventsClient {
    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Post event) {
        IShipPilot playerPilot;
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FontRenderer fontRenderer = minecraft.field_71466_p;
        if (fontRenderer != null && player != null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT && (playerPilot = (IShipPilot)player).isPiloting()) {
            BlockPos tilePilotedPos = playerPilot.getPosBeingControlled();
            TileEntity pilotedTile = player.func_130014_f_().func_175625_s(tilePilotedPos);
            if (pilotedTile instanceof ITileEntityPilotable) {
                ITileEntityPilotable pilotedControlEntity = (ITileEntityPilotable)pilotedTile;
                ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
                pilotedControlEntity.renderPilotText(fontRenderer, scaledresolution);
            }
        }
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        ResourceLocation mainCoreInventoryTexture = new ResourceLocation("vs_control", "items/main_core");
        ResourceLocation smallCoreInventoryTexture = new ResourceLocation("vs_control", "items/small_core");
        event.getMap().func_174942_a(mainCoreInventoryTexture);
        event.getMap().func_174942_a(smallCoreInventoryTexture);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ResourceLocation modelResourceLocation = new ResourceLocation("vs_control", "item/infuser_core_main");
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelResourceLocation);
            IBakedModel inventoryModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            IBakedModel handModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)new ModelResourceLocation("vs_control:" + ValkyrienSkiesControl.INSTANCE.physicsCore.func_77658_a().substring(5), "inventory"));
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("vs_control:testmodel", "inventory"), (Object)new InfuserCoreBakedModel(handModel, inventoryModel));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

