/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.fixes;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.ships.ship_world.IWorldVS;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class FixAccurateRain {
    public static BlockPos getRainPosFromShips(World world, BlockPos originalHeight) {
        if (VSConfig.accurateRain && Minecraft.func_71410_x().field_71439_g != null) {
            AxisAlignedBB boundingBox = new AxisAlignedBB((double)originalHeight.func_177958_n() - 0.5, 0.0, (double)originalHeight.func_177952_p() - 0.5, (double)originalHeight.func_177958_n() + 0.5, 255.0, (double)originalHeight.func_177952_p() + 0.5);
            List<PhysicsObject> physicsObjectList = ValkyrienUtils.getPhysObjWorld(world).getPhysObjectsInAABB(boundingBox);
            Vec3d traceStart = new Vec3d((double)originalHeight.func_177958_n() + 0.5, Minecraft.func_71410_x().field_71439_g.field_70163_u + 50.0, (double)originalHeight.func_177952_p() + 0.5);
            Vec3d traceEnd = new Vec3d((double)originalHeight.func_177958_n() + 0.5, (double)originalHeight.func_177956_o() + 0.5, (double)originalHeight.func_177952_p() + 0.5);
            if (traceStart.field_72448_b < traceEnd.field_72448_b) {
                return originalHeight;
            }
            for (PhysicsObject physicsObject : physicsObjectList) {
                RayTraceResult result = ((IWorldVS)world).rayTraceBlocksInShip(traceStart, traceEnd, true, true, false, physicsObject);
                if (result == null || result.func_178782_a() == null || result.field_72313_a == RayTraceResult.Type.MISS) continue;
                Vector3d blockPosVector = JOML.convertDouble((Vec3i)result.func_178782_a()).add(0.5, 0.5, 0.5);
                physicsObject.getShipTransformationManager().getCurrentTickTransform().getSubspaceToGlobal().transformPosition(blockPosVector);
                return new BlockPos((double)originalHeight.func_177958_n(), blockPosVector.y(), (double)originalHeight.func_177952_p());
            }
        }
        return originalHeight;
    }
}

