/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.multithreaded;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.collision.ShipCollisionTask;
import org.valkyrienskies.mod.common.collision.WaterForcesTask;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.network.ShipTransformUpdateMessage;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IHasShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.multithreaded.IPhysTimeTask;

public class VSWorldPhysicsLoop
implements Runnable {
    private static final Logger log = LogManager.getLogger(VSWorldPhysicsLoop.class);
    private static final long TICK_TIME_QUEUE = 100L;
    private static int worldPhysicsLoopId = 0;
    private final World hostWorld;
    private final Queue<Long> latestPhysicsTickTimes;
    private volatile boolean threadRunning;
    private final Queue<Runnable> taskQueue;
    private ImmutableList<PhysicsObject> immutableShipsList;
    private final ConcurrentLinkedQueue<IPhysTimeTask> recurringTasks;
    private final String name = "VS World Physics Task " + worldPhysicsLoopId;
    private long lastPacketSendTime = 0L;

    public VSWorldPhysicsLoop(World host) {
        ++worldPhysicsLoopId;
        this.hostWorld = host;
        this.threadRunning = true;
        this.latestPhysicsTickTimes = new ConcurrentLinkedQueue<Long>();
        this.taskQueue = new ConcurrentLinkedQueue<Runnable>();
        this.immutableShipsList = ImmutableList.of();
        this.recurringTasks = new ConcurrentLinkedQueue();
        log.trace(this.name + " created.");
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isSinglePlayerPaused() {
        return Minecraft.func_71410_x().func_147113_T();
    }

    public void addScheduledTask(Runnable r) {
        this.taskQueue.add(r);
    }

    private static long getNsPerTick() {
        return (long)(1.0E9 / VSConfig.targetTps);
    }

    public void addRecurringTask(IPhysTimeTask physTask) {
        this.recurringTasks.add(physTask);
    }

    @Override
    public void run() {
        while (this.threadRunning) {
            boolean tickPhysics;
            MinecraftServer mcServer = this.hostWorld.func_73046_m();
            assert (mcServer != null);
            boolean bl = tickPhysics = mcServer.func_71278_l() && (mcServer.func_71262_S() || !VSWorldPhysicsLoop.isSinglePlayerPaused());
            if (tickPhysics) {
                double timeToSimulate = VSConfig.getTimeSimulatedPerTick();
                long idealTickTime = (long)(1.0E9 / VSConfig.targetTps);
                long physTickStartTime = System.nanoTime();
                this.physicsTick(timeToSimulate);
                long physTickEndTime = System.nanoTime();
                long physTickDuration = physTickEndTime - physTickStartTime;
                if (physTickDuration < idealTickTime) {
                    long sleepMillis = (idealTickTime - physTickDuration) / 1000000L;
                    try {
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long physTickDurationIncludingSleep = System.nanoTime() - physTickStartTime;
                this.latestPhysicsTickTimes.add(physTickDurationIncludingSleep);
                if ((long)this.latestPhysicsTickTimes.size() <= 100L) continue;
                this.latestPhysicsTickTimes.remove();
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.trace(this.name + " killed");
    }

    private void physicsTick(double delta) {
        this.immutableShipsList = ((IHasShipManager)this.hostWorld).getManager().getAllLoadedThreadSafe();
        this.recurringTasks.forEach(t -> t.runTask(delta));
        this.taskQueue.forEach(Runnable::run);
        this.taskQueue.clear();
        ArrayList<PhysicsObject> physicsEntitiesToDoPhysics = new ArrayList<PhysicsObject>();
        for (PhysicsObject physicsObject : this.immutableShipsList) {
            if (!physicsObject.isPhysicsReady() || !physicsObject.isPhysicsEnabled() || physicsObject.getCachedSurroundingChunks() == null) continue;
            physicsEntitiesToDoPhysics.add(physicsObject);
        }
        this.tickThePhysicsAndCollision(physicsEntitiesToDoPhysics, delta);
        long currentTimeMillis = System.currentTimeMillis();
        double secondsSinceLastPacket = (double)(currentTimeMillis - this.lastPacketSendTime) / 1000.0;
        if (secondsSinceLastPacket > 0.04) {
            this.lastPacketSendTime = currentTimeMillis;
            try {
                ShipTransformUpdateMessage shipTransformUpdateMessage = new ShipTransformUpdateMessage();
                int dimensionID = this.hostWorld.field_73011_w.getDimension();
                shipTransformUpdateMessage.setDimensionID(dimensionID);
                for (PhysicsObject physicsObject : this.immutableShipsList) {
                    UUID shipUUID = physicsObject.getUuid();
                    ShipTransform shipTransform = physicsObject.getShipTransformationManager().getCurrentPhysicsTransform();
                    AxisAlignedBB shipBB = physicsObject.getPhysicsTransformAABB();
                    shipTransformUpdateMessage.addData(shipUUID, shipTransform, shipBB);
                }
                ValkyrienSkiesMod.physWrapperTransformUpdateNetwork.sendToDimension((IMessage)shipTransformUpdateMessage, shipTransformUpdateMessage.getDimensionID());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void tickThePhysicsAndCollision(List<PhysicsObject> shipsWithPhysics, double timeStep) {
        ArrayList<ShipCollisionTask> collisionTasks = new ArrayList<ShipCollisionTask>(shipsWithPhysics.size() * 2);
        ArrayList<WaterForcesTask> waterForcesTasks = new ArrayList<WaterForcesTask>();
        for (PhysicsObject wrapper : shipsWithPhysics) {
            try {
                wrapper.getPhysicsCalculations().rawPhysTickPreCol(timeStep);
                wrapper.getPhysicsCalculations().getWorldWaterCollider().tickUpdatingTheCollisionCache();
                waterForcesTasks.addAll(wrapper.getPhysicsCalculations().getWorldWaterCollider().generateWaterForceTasks());
                wrapper.getPhysicsCalculations().getWorldCollision().tickUpdatingTheCollisionCache();
                wrapper.getPhysicsCalculations().getWorldCollision().splitIntoCollisionTasks(collisionTasks);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<Callable<Void>> allTasks = new ArrayList<Callable<Void>>();
        allTasks.addAll(collisionTasks);
        allTasks.addAll(waterForcesTasks);
        try {
            ValkyrienSkiesMod.getPhysicsThreadPool().invokeAll(allTasks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (WaterForcesTask waterForcesTask : waterForcesTasks) {
            waterForcesTask.addForcesToShip();
        }
        for (ShipCollisionTask task : collisionTasks) {
            task.getToTask().processCollisionTask(task);
        }
        for (PhysicsObject wrapper : shipsWithPhysics) {
            try {
                wrapper.getPhysicsCalculations().rawPhysTickPostCol();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void kill() {
        log.trace(this.name + " marked for death.");
        this.threadRunning = false;
    }

    public long getAveragePhysicsTickTimeNano() {
        if ((long)this.latestPhysicsTickTimes.size() >= 100L) {
            long average = 0L;
            for (Long tickTime : this.latestPhysicsTickTimes) {
                average += tickTime.longValue();
            }
            return average / 100L;
        }
        return VSWorldPhysicsLoop.getNsPerTick();
    }

    public String getName() {
        return this.name;
    }
}

