/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.jackson.minecraft;

import java.io.IOException;
import net.minecraft.util.math.ChunkPos;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonParser;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.DeserializationContext;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.JsonNode;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.SerializerProvider;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class ChunkPosSerialization {
    private static int getChunkX(long chunkPos) {
        return (int)(chunkPos & 0xFFFFFFFFL);
    }

    private static int getChunkZ(long chunkPos) {
        return (int)(chunkPos >> 32 & 0xFFFFFFFFL);
    }

    public static class Serializer
    extends StdSerializer<ChunkPos> {
        public Serializer() {
            this((Class<ChunkPos>)null);
        }

        public Serializer(Class<ChunkPos> vc) {
            super(vc);
        }

        @Override
        public void serialize(ChunkPos value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField("chunkPos", ChunkPos.func_77272_a((int)value.field_77276_a, (int)value.field_77275_b));
            gen.writeEndObject();
        }
    }

    public static class Deserializer
    extends StdDeserializer<ChunkPos> {
        public Deserializer() {
            this((Class<ChunkPos>)null);
        }

        public Deserializer(Class<ChunkPos> vc) {
            super(vc);
        }

        @Override
        public ChunkPos deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            long chunkPos = node.get("chunkPos").longValue();
            return new ChunkPos(ChunkPosSerialization.getChunkX(chunkPos), ChunkPosSerialization.getChunkZ(chunkPos));
        }
    }
}

