/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.jackson.minecraft;

import java.io.IOException;
import net.minecraft.util.math.AxisAlignedBB;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonParser;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.DeserializationContext;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.JsonNode;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.SerializerProvider;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class AxisAlignedBBSerialization {

    public static class Serializer
    extends StdSerializer<AxisAlignedBB> {
        public Serializer() {
            this((Class<AxisAlignedBB>)null);
        }

        public Serializer(Class<AxisAlignedBB> vc) {
            super(vc);
        }

        @Override
        public void serialize(AxisAlignedBB value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField("minX", value.field_72340_a);
            gen.writeNumberField("minY", value.field_72338_b);
            gen.writeNumberField("minZ", value.field_72339_c);
            gen.writeNumberField("maxX", value.field_72336_d);
            gen.writeNumberField("maxY", value.field_72337_e);
            gen.writeNumberField("maxZ", value.field_72334_f);
            gen.writeEndObject();
        }
    }

    public static class Deserializer
    extends StdDeserializer<AxisAlignedBB> {
        public Deserializer() {
            this((Class<AxisAlignedBB>)null);
        }

        public Deserializer(Class<AxisAlignedBB> vc) {
            super(vc);
        }

        @Override
        public AxisAlignedBB deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            double minX = node.get("minX").doubleValue();
            double minY = node.get("minY").doubleValue();
            double minZ = node.get("minZ").doubleValue();
            double maxX = node.get("maxX").doubleValue();
            double maxY = node.get("maxY").doubleValue();
            double maxZ = node.get("maxZ").doubleValue();
            return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }
}

