/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.jackson;

import org.valkyrienskies.deps.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ObjectMapper;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import org.valkyrienskies.deps.com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import org.valkyrienskies.mod.common.util.jackson.JOMLSerializationModule;
import org.valkyrienskies.mod.common.util.jackson.MinecraftSerializationModule;
import org.valkyrienskies.mod.common.util.jackson.annotations.VSAnnotationIntrospector;

public class VSJacksonUtil {
    private static CBORMapper defaultMapper;
    private static CBORMapper packetMapper;

    public static ObjectMapper getDefaultMapper() {
        if (defaultMapper == null) {
            CBORMapper mapper = new CBORMapper();
            VSJacksonUtil.configureMapper(mapper);
            defaultMapper = mapper;
        }
        return defaultMapper;
    }

    public static ObjectMapper getPacketMapper() {
        if (packetMapper == null) {
            CBORMapper mapper = new CBORMapper();
            VSJacksonUtil.configurePacketMapper(mapper);
            packetMapper = mapper;
        }
        return packetMapper;
    }

    public static void configurePacketMapper(ObjectMapper mapper) {
        VSJacksonUtil.configureMapper(mapper);
        mapper.setAnnotationIntrospector(VSAnnotationIntrospector.instance);
    }

    public static void configureMapper(ObjectMapper mapper) {
        mapper.registerModule(new MinecraftSerializationModule()).registerModule(new JOMLSerializationModule()).setVisibility((VisibilityChecker<?>)mapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
    }
}

