/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.datastructures;

import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonParser;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.DeserializationContext;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.JsonNode;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ObjectMapper;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.SerializerProvider;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.valkyrienskies.mod.common.util.VSIterationUtils;
import org.valkyrienskies.mod.common.util.datastructures.FastMinMaxMap;
import org.valkyrienskies.mod.common.util.datastructures.IBlockPosSetAABB;
import org.valkyrienskies.mod.common.util.datastructures.SmallBlockPosSet;

@JsonDeserialize(using=WrapperSmallBlockPosSetAABBDeserializer.class)
@JsonSerialize(using=WrapperSmallBlockPosSetAABBSerializer.class)
public class SmallBlockPosSetAABB
implements IBlockPosSetAABB {
    private final SmallBlockPosSet blockPosSet;
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private final FastMinMaxMap xMap;
    private final FastMinMaxMap yMap;
    private final FastMinMaxMap zMap;

    public SmallBlockPosSetAABB(int centerX, int centerY, int centerZ, int xSize, int ySize, int zSize) {
        this(new SmallBlockPosSet(centerX, centerZ), centerX, centerY, centerZ, xSize, ySize, zSize);
    }

    private SmallBlockPosSetAABB(SmallBlockPosSet blockPosSet, int centerX, int centerY, int centerZ, int xSize, int ySize, int zSize) {
        this.blockPosSet = blockPosSet;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.xMap = new FastMinMaxMap(xSize);
        this.yMap = new FastMinMaxMap(ySize);
        this.zMap = new FastMinMaxMap(zSize);
    }

    @Override
    @Nullable
    public AxisAlignedBB makeAABB() {
        if (this.blockPosSet.isEmpty()) {
            return null;
        }
        int minX = this.xMap.getFront() - this.xSize / 2;
        int maxX = this.xMap.getBack() - this.xSize / 2;
        int minY = this.yMap.getFront() - this.ySize / 2;
        int maxY = this.yMap.getBack() - this.ySize / 2;
        int minZ = this.zMap.getFront() - this.zSize / 2;
        int maxZ = this.zMap.getBack() - this.zSize / 2;
        return new AxisAlignedBB((double)(minX += this.blockPosSet.getCenterX()), (double)minY, (double)(minZ += this.blockPosSet.getCenterZ()), (double)(maxX += this.blockPosSet.getCenterX()), (double)maxY, (double)(maxZ += this.blockPosSet.getCenterZ()));
    }

    @Override
    public boolean add(int x, int y, int z) throws IllegalArgumentException {
        boolean setResult = this.blockPosSet.add(x, y, z);
        if (setResult) {
            this.incrementAABBMaker(x, y, z);
        }
        return setResult;
    }

    private void incrementAABBMaker(int x, int y, int z) {
        this.xMap.increment(x - this.blockPosSet.getCenterX() + this.xSize / 2);
        this.yMap.increment(y + this.ySize / 2);
        this.zMap.increment(z - this.blockPosSet.getCenterZ() + this.zSize / 2);
    }

    @Override
    public boolean remove(int x, int y, int z) {
        boolean setResult = this.blockPosSet.remove(x, y, z);
        if (setResult) {
            this.decrementAABBMaker(x, y, z);
        }
        return setResult;
    }

    private void decrementAABBMaker(int x, int y, int z) {
        this.xMap.decrement(x - this.blockPosSet.getCenterX() + this.xSize / 2);
        this.yMap.decrement(y + this.ySize / 2);
        this.zMap.decrement(z - this.blockPosSet.getCenterZ() + this.zSize / 2);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.blockPosSet.contains(x, y, z);
    }

    @Override
    public boolean canStore(int x, int y, int z) {
        return this.blockPosSet.canStore(x, y, z);
    }

    @Override
    public int size() {
        return this.blockPosSet.size();
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return this.blockPosSet.iterator();
    }

    @Override
    public void clear() {
        this.blockPosSet.clear();
        this.xMap.clear();
        this.yMap.clear();
        this.zMap.clear();
    }

    @Override
    public void forEach(@Nonnull VSIterationUtils.IntTernaryConsumer action) {
        this.blockPosSet.forEach(action);
    }

    public static class WrapperSmallBlockPosSetAABBDeserializer
    extends StdDeserializer<SmallBlockPosSetAABB> {
        private final ObjectMapper objectMapper = new ObjectMapper();

        public WrapperSmallBlockPosSetAABBDeserializer() {
            super((Class)null);
        }

        @Override
        public SmallBlockPosSetAABB deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            SmallBlockPosSet blockPosSet = this.objectMapper.treeToValue(node.get("blockPosSet"), SmallBlockPosSet.class);
            int centerX = node.get("centerX").asInt();
            int centerY = node.get("centerY").asInt();
            int centerZ = node.get("centerZ").asInt();
            int xSize = node.get("xSize").asInt();
            int ySize = node.get("ySize").asInt();
            int zSize = node.get("zSize").asInt();
            SmallBlockPosSetAABB wrapper = new SmallBlockPosSetAABB(blockPosSet, centerX, centerY, centerZ, xSize, ySize, zSize);
            blockPosSet.forEach((x$0, x$1, x$2) -> wrapper.incrementAABBMaker(x$0, x$1, x$2));
            return wrapper;
        }
    }

    public static class WrapperSmallBlockPosSetAABBSerializer
    extends StdSerializer<SmallBlockPosSetAABB> {
        public WrapperSmallBlockPosSetAABBSerializer() {
            super((Class)null);
        }

        @Override
        public void serialize(SmallBlockPosSetAABB value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("blockPosSet", value.blockPosSet);
            gen.writeNumberField("centerX", value.centerX);
            gen.writeNumberField("centerY", value.centerY);
            gen.writeNumberField("centerZ", value.centerZ);
            gen.writeNumberField("xSize", value.xSize);
            gen.writeNumberField("ySize", value.ySize);
            gen.writeNumberField("zSize", value.zSize);
            gen.writeEndObject();
        }
    }
}

