/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.datastructures;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonParser;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.DeserializationContext;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.JsonNode;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.SerializerProvider;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.valkyrienskies.mod.common.util.VSIterationUtils;
import org.valkyrienskies.mod.common.util.datastructures.IBlockPosSet;

@JsonDeserialize(using=SmallBlockPosSetDeserializer.class)
@JsonSerialize(using=SmallBlockPosSetSerializer.class)
public class SmallBlockPosSet
implements IBlockPosSet {
    private static final int BOT_12_BITS = 4095;
    private static final int BOT_8_BITS = 255;
    @Nonnull
    private final TIntList compressedBlockPosList = new TIntArrayList();
    @Nonnull
    private final TIntIntMap listValueToIndex = new TIntIntHashMap();
    private final int centerX;
    private final int centerZ;

    public SmallBlockPosSet(int centerX, int centerZ) {
        this.centerX = centerX;
        this.centerZ = centerZ;
    }

    @Override
    public boolean add(int x, int y, int z) throws IllegalArgumentException {
        if (!this.canStore(x, y, z)) {
            throw new IllegalArgumentException("Cannot store block position at <" + x + "," + y + "," + z + ">");
        }
        int compressedPos = this.compress(x, y, z);
        if (this.listValueToIndex.containsKey(compressedPos)) {
            return false;
        }
        this.compressedBlockPosList.add(compressedPos);
        this.listValueToIndex.put(compressedPos, this.compressedBlockPosList.size() - 1);
        return true;
    }

    @Override
    public boolean remove(int x, int y, int z) {
        if (!this.canStore(x, y, z)) {
            throw new IllegalArgumentException("Cannot remove block position at <" + x + "," + y + "," + z + ">");
        }
        int compressedPos = this.compress(x, y, z);
        if (!this.listValueToIndex.containsKey(compressedPos)) {
            return false;
        }
        int elementIndex = this.listValueToIndex.get(compressedPos);
        if (elementIndex == this.compressedBlockPosList.size() - 1) {
            this.compressedBlockPosList.removeAt(elementIndex);
        } else {
            int lastElementValue = this.compressedBlockPosList.removeAt(this.compressedBlockPosList.size() - 1);
            this.compressedBlockPosList.set(elementIndex, lastElementValue);
            this.listValueToIndex.put(lastElementValue, elementIndex);
        }
        this.listValueToIndex.remove(compressedPos);
        return true;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (!this.canStore(x, y, z)) {
            return false;
        }
        return this.listValueToIndex.containsKey(this.compress(x, y, z));
    }

    @Override
    public boolean canStore(int x, int y, int z) {
        int xLocal = x - this.centerX;
        int zLocal = z - this.centerZ;
        return !(y < 0 | y > 255 | xLocal < -2048 | xLocal > 2047 | zLocal < -2048 | zLocal > 2047);
    }

    @Override
    public int size() {
        return this.compressedBlockPosList.size();
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return new SmallBlockPosIterator(this.compressedBlockPosList.iterator());
    }

    @Override
    public void forEach(@Nonnull VSIterationUtils.IntTernaryConsumer action) {
        for (int compressed : this.compressedBlockPosList) {
            int z = compressed >> 20;
            int y = compressed >> 12 & 0xFF;
            int x = (compressed & 0xFFF) << 20 >> 20;
            action.accept(x + this.centerX, y, z + this.centerZ);
        }
    }

    @Override
    public void clear() {
        this.compressedBlockPosList.clear();
        this.listValueToIndex.clear();
    }

    @Nonnull
    private BlockPos decompress(int compressed) {
        int z = compressed >> 20;
        int y = compressed >> 12 & 0xFF;
        int x = (compressed & 0xFFF) << 20 >> 20;
        return new BlockPos(x + this.centerX, y, z + this.centerZ);
    }

    private void decompressMutable(int compressed, BlockPos.MutableBlockPos mutableBlockPos) {
        int z = compressed >> 20;
        int y = compressed >> 12 & 0xFF;
        int x = (compressed & 0xFFF) << 20 >> 20;
        mutableBlockPos.func_181079_c(x + this.centerX, y, z + this.centerZ);
    }

    private int compress(int x, int y, int z) {
        int xBits = x - this.centerX & 0xFFF;
        int yBits = y & 0xFF;
        int zBits = z - this.centerZ & 0xFFF;
        return xBits | yBits << 12 | zBits << 20;
    }

    @Override
    public void forEachUnsafe(@Nonnull VSIterationUtils.IntTernaryConsumer action) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int curIndex = 0; this.compressedBlockPosList.size() >= curIndex; ++curIndex) {
            try {
                int currentValue = this.compressedBlockPosList.get(curIndex);
                this.decompressMutable(currentValue, mutableBlockPos);
                action.accept(mutableBlockPos.func_177958_n(), mutableBlockPos.func_177956_o(), mutableBlockPos.func_177952_p());
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public static class SmallBlockPosSetDeserializer
    extends StdDeserializer<SmallBlockPosSet> {
        public SmallBlockPosSetDeserializer() {
            super((Class)null);
        }

        @Override
        public SmallBlockPosSet deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            int centerX = node.get("centerX").asInt();
            int centerZ = node.get("centerZ").asInt();
            SmallBlockPosSet set = new SmallBlockPosSet(centerX, centerZ);
            for (JsonNode elem : node.get("positions")) {
                int positionInt = elem.asInt();
                set.compressedBlockPosList.add(positionInt);
                set.listValueToIndex.put(positionInt, set.compressedBlockPosList.size() - 1);
            }
            return set;
        }
    }

    public static class SmallBlockPosSetSerializer
    extends StdSerializer<SmallBlockPosSet> {
        public SmallBlockPosSetSerializer() {
            super((Class)null);
        }

        @Override
        public void serialize(SmallBlockPosSet value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("positions");
            gen.writeStartArray(value.compressedBlockPosList.size());
            TIntIterator iter = value.compressedBlockPosList.iterator();
            while (iter.hasNext()) {
                gen.writeNumber(iter.next());
            }
            gen.writeEndArray();
            gen.writeNumberField("centerX", value.centerX);
            gen.writeNumberField("centerZ", value.centerZ);
            gen.writeEndObject();
        }
    }

    private class SmallBlockPosIterator
    implements Iterator<BlockPos> {
        private final TIntIterator iterator;

        SmallBlockPosIterator(TIntIterator intIterator) {
            this.iterator = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public BlockPos next() {
            return SmallBlockPosSet.this.decompress(this.iterator.next());
        }
    }
}

