/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.cqengine;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.index.support.Factory;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.stored.StoredResultSet;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableIndex;

public class UpdatableHashIndex<A, O>
extends HashIndex<A, O>
implements UpdatableIndex<O> {
    ConcurrentMap<O, Iterable<A>> reverseMap;

    protected UpdatableHashIndex(Factory<ConcurrentMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Factory<ConcurrentMap<O, Iterable<A>>> reverseMapFactory, Attribute<O, A> attribute) {
        super(indexMapFactory, valueSetFactory, attribute);
        this.reverseMap = reverseMapFactory.create();
    }

    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        for (Object object : objectSet) {
            Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
            this.reverseMap.put(object, attributeValues);
        }
        return super.addAll(objectSet, queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            ConcurrentMap indexMap = this.indexMap;
            for (Object object : objectSet) {
                Iterable attributeValues = this.reverseMap.getOrDefault(object, Collections.emptyList());
                for (Object attributeValue : attributeValues) {
                    StoredResultSet valueSet = (StoredResultSet)indexMap.get(attributeValue = this.getQuantizedValue(attributeValue));
                    if (valueSet == null) continue;
                    modified |= valueSet.remove(object);
                    if (!valueSet.isEmpty()) continue;
                    indexMap.remove(attributeValue);
                }
                this.reverseMap.remove(object);
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            for (Object object : objectSet) {
                Iterable oldAttributeValues = (Iterable)this.reverseMap.get(object);
                for (Object oldAttributeValue : oldAttributeValues) {
                    StoredResultSet oldAttribute = (StoredResultSet)this.indexMap.get(oldAttributeValue);
                    oldAttribute.remove(object);
                }
                Iterable newAttributeValues = this.getAttribute().getValues(object, queryOptions);
                for (Object newAttributeValue : newAttributeValues) {
                    StoredResultSet newAttribute = this.indexMap.computeIfAbsent(newAttributeValue, k -> (StoredResultSet)this.valueSetFactory.create());
                    newAttribute.add(object);
                }
                this.reverseMap.put(object, newAttributeValues);
            }
        }
        finally {
            objectSet.close();
        }
    }

    public static <A, O> UpdatableHashIndex<A, O> onAttribute(Attribute<O, A> attribute) {
        return UpdatableHashIndex.onAttribute(new HashIndex.DefaultIndexMapFactory(), attribute);
    }

    public static <A, O> UpdatableHashIndex<A, O> onAttribute(Factory<ConcurrentMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Attribute<O, A> attribute) {
        return new UpdatableHashIndex<A, O>(indexMapFactory, valueSetFactory, new DefaultReverseMapFactory(), attribute);
    }

    public static <A, O> UpdatableHashIndex<A, O> onAttribute(Factory<ConcurrentMap<A, StoredResultSet<O>>> indexMapFactory, Attribute<O, A> attribute) {
        return UpdatableHashIndex.onAttribute(indexMapFactory, new HashIndex.DefaultValueSetFactory(), new DefaultReverseMapFactory(), attribute);
    }

    public static <A, O> UpdatableHashIndex<A, O> onAttribute(Factory<ConcurrentMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Factory<ConcurrentMap<O, Iterable<A>>> reverseMapFactory, Attribute<O, A> attribute) {
        return new UpdatableHashIndex<A, O>(indexMapFactory, valueSetFactory, reverseMapFactory, attribute);
    }

    public static class DefaultReverseMapFactory<O, A>
    implements Factory<ConcurrentMap<O, A>> {
        @Override
        public ConcurrentMap<O, A> create() {
            return new ConcurrentHashMap();
        }
    }
}

