/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.cqengine;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.engine.CollectionQueryEngine;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.compound.CompoundIndex;
import com.googlecode.cqengine.index.compound.support.CompoundAttribute;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableFallbackIndex;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableIndex;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableQueryEngine;

public class UpdatableCollectionQueryEngine<O>
extends CollectionQueryEngine<O>
implements UpdatableQueryEngine<O> {
    private ConcurrentMap<CompoundAttribute<O>, CompoundIndex<O>> compoundIndexes;
    private ConcurrentMap<Attribute<O, ?>, Set<UpdatableIndex<O>>> attributeIndexes;
    private UpdatableFallbackIndex<O> fallbackIndex = new UpdatableFallbackIndex();

    @Override
    public void updateAll(ObjectSet<O> objectSet, Attribute<O, ?> onAttribute, QueryOptions queryOptions) {
        this.forEachIndexOnAttributeDo(index -> {
            UpdatableIndex updatableIndex = (UpdatableIndex)index;
            updatableIndex.updateAll(objectSet, queryOptions);
            return true;
        }, onAttribute);
    }

    void forEachIndexOnAttributeDo(IndexOperation<O> indexOperation, Attribute<O, ?> attribute) {
        if (attribute instanceof CompoundAttribute) {
            CompoundIndex compoundIndex = (CompoundIndex)this.getCompoundIndexes().get(attribute);
            indexOperation.perform(compoundIndex);
        } else {
            Set indexesForAttribute = (Set)this.getAttributeIndexes().get(attribute);
            for (Index index : indexesForAttribute) {
                boolean continueIterating = indexOperation.perform(index);
                if (continueIterating) continue;
                return;
            }
        }
        indexOperation.perform(this.fallbackIndex);
    }

    private ConcurrentMap<Attribute<O, ?>, Set<UpdatableIndex<O>>> getAttributeIndexes() {
        try {
            if (this.attributeIndexes == null) {
                Field attributeIndexes = CollectionQueryEngine.class.getDeclaredField("attributeIndexes");
                attributeIndexes.setAccessible(true);
                this.attributeIndexes = (ConcurrentMap)attributeIndexes.get(this);
            }
            return this.attributeIndexes;
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ConcurrentMap<CompoundAttribute<O>, CompoundIndex<O>> getCompoundIndexes() {
        try {
            if (this.compoundIndexes == null) {
                Field compoundIndexesField = CollectionQueryEngine.class.getDeclaredField("compoundIndexes");
                compoundIndexesField.setAccessible(true);
                this.compoundIndexes = (ConcurrentMap)compoundIndexesField.get(this);
            }
            return this.compoundIndexes;
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }

    static interface IndexOperation<O> {
        public boolean perform(Index<O> var1);
    }
}

