/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.capability.VSCapabilityRegistry;
import org.valkyrienskies.mod.common.capability.VSWorldDataCapability;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.entity.EntityMountable;
import org.valkyrienskies.mod.common.entity.EntityShipMovementData;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.block_relocation.BlockFinder;
import org.valkyrienskies.mod.common.ships.chunk_claims.ShipChunkAllocator;
import org.valkyrienskies.mod.common.ships.chunk_claims.VSChunkClaim;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityShipMountData;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;
import org.valkyrienskies.mod.common.ships.ship_transform.CoordinateSpaceType;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IHasShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.IPhysObjectWorld;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.ships.ship_world.VSWorldData;
import org.valkyrienskies.mod.common.ships.ship_world.WorldServerShipManager;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.VSMath;
import org.valkyrienskies.mod.common.util.names.NounListNameGenerator;
import valkyrienwarfare.api.TransformType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class ValkyrienUtils {
    public static Optional<PhysicsObject> getPhysoManagingBlock(@Nullable World world, @Nullable BlockPos pos) {
        return ValkyrienUtils.getShipManagingBlock(world, pos).map(shipData -> ValkyrienUtils.getPhysObjWorld(world).getPhysObjectFromUUID(shipData.getUuid()));
    }

    public static Optional<PhysicsObject> getPhysoManagingBlockThreadSafe(@Nullable World world, @Nullable BlockPos pos) {
        for (PhysicsObject physicsObject : ValkyrienUtils.getPhysObjWorld(world).getAllLoadedThreadSafe()) {
            if (!physicsObject.getChunkClaim().containsBlock(pos)) continue;
            return Optional.of(physicsObject);
        }
        return Optional.empty();
    }

    public static Optional<ShipData> getShipManagingBlock(@Nullable World world, @Nullable BlockPos pos) {
        if (world == null || pos == null || !ShipChunkAllocator.isChunkInShipyard(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return Optional.empty();
        }
        return QueryableShipData.get(world).getShipFromChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static AxisAlignedBB getAABBInGlobal(AxisAlignedBB axisAlignedBB, @Nullable World world, @Nullable BlockPos pos) {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(world, pos);
        if (physicsObject.isPresent()) {
            Polygon bbAsPoly = new Polygon(axisAlignedBB, physicsObject.get().getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
            return bbAsPoly.getEnclosedAABB();
        }
        return axisAlignedBB;
    }

    public static EntityShipMountData getMountedShipAndPos(Entity entity) {
        EntityMountable mountable;
        Optional<PhysicsObject> mountedShip;
        Entity ridingEntity = entity.field_184239_as;
        if (ridingEntity instanceof EntityMountable && (mountedShip = (mountable = (EntityMountable)ridingEntity).getMountedShip()).isPresent()) {
            return new EntityShipMountData(mountedShip.get(), mountable.getMountPos());
        }
        return new EntityShipMountData();
    }

    public static void fixEntityToShip(Entity toFix, Vector3dc posInLocal, PhysicsObject mountingShip) {
        World world = mountingShip.getWorld();
        EntityMountable entityMountable = new EntityMountable(world, JOML.toMinecraft(posInLocal), CoordinateSpaceType.SUBSPACE_COORDINATES, mountingShip.getReferenceBlockPos());
        world.func_72838_d((Entity)entityMountable);
        toFix.func_184220_m((Entity)entityMountable);
    }

    private static VSWorldDataCapability getWorldDataCapability(World world) {
        VSWorldDataCapability worldData = (VSWorldDataCapability)world.getCapability(VSCapabilityRegistry.VS_WORLD_DATA, null);
        if (worldData == null) {
            throw new IllegalStateException("World " + world + " doesn't have an VSWorldDataCapability. This is wrong!");
        }
        return worldData;
    }

    public static QueryableShipData getQueryableData(World world) {
        return ((VSWorldData)ValkyrienUtils.getWorldDataCapability(world).get()).getQueryableShipData();
    }

    public static ShipChunkAllocator getShipChunkAllocator(World world) {
        return ((VSWorldData)ValkyrienUtils.getWorldDataCapability(world).get()).getShipChunkAllocator();
    }

    public static WorldServerShipManager getServerShipManager(World world) {
        return (WorldServerShipManager)((IHasShipManager)world).getManager();
    }

    public static ShipData createNewShip(World world, BlockPos physInfuserPos) {
        String name = NounListNameGenerator.getInstance().generateName();
        UUID shipID = UUID.randomUUID();
        VSChunkClaim chunkClaim = ValkyrienUtils.getShipChunkAllocator(world).allocateNextChunkClaim();
        Vector3d centerOfMassInitial = VSMath.toVector3d((Vec3i)chunkClaim.getRegionCenter());
        Vector3d shipPosInitial = VSMath.toVector3d((Vec3i)physInfuserPos);
        ShipTransform initial = new ShipTransform(shipPosInitial, centerOfMassInitial);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(shipPosInitial.x(), shipPosInitial.y(), shipPosInitial.z(), shipPosInitial.x(), shipPosInitial.y(), shipPosInitial.z());
        return ShipData.createData(QueryableShipData.get(world).getAllShips(), name, chunkClaim, shipID, initial, axisAlignedBB);
    }

    public static Iterable<PhysicsObject> getPhysosLoadedInWorld(World world) {
        return ((IHasShipManager)world).getManager().getAllLoadedPhysObj();
    }

    public static void assembleShipAsOrderedByPlayer(World world, @Nullable EntityPlayerMP creator, BlockPos physicsInfuserPos, BlockFinder.BlockFinderType blockFinderType) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This method cannot be invoked on client side!");
        }
        if (!(world instanceof WorldServer)) {
            throw new IllegalStateException("The world " + world + " wasn't an instance of WorldServer");
        }
        ShipData shipData = ValkyrienUtils.createNewShip(world, physicsInfuserPos);
        ((WorldServerShipManager)ValkyrienUtils.getPhysObjWorld(world)).queueShipSpawn(shipData, physicsInfuserPos, blockFinderType);
    }

    public static IPhysObjectWorld getPhysObjWorld(World world) {
        return ((IHasShipManager)world).getManager();
    }

    public static void transformEntity(Matrix4dc transform, Entity entity, boolean transformEntityBoundingBox) {
        Vec3d entityLookMc = entity.func_70676_i(1.0f);
        Vector3d entityPos = new Vector3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vector3d entityLook = new Vector3d(entityLookMc.field_72450_a, entityLookMc.field_72448_b, entityLookMc.field_72449_c);
        Vector3d entityMotion = new Vector3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        if (entity instanceof EntityFireball) {
            EntityFireball ball = (EntityFireball)entity;
            entityMotion.x = ball.field_70232_b;
            entityMotion.y = ball.field_70233_c;
            entityMotion.z = ball.field_70230_d;
        }
        transform.transformPosition(entityPos);
        transform.transformDirection(entityLook);
        transform.transformDirection(entityMotion);
        entityLook.normalize();
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            living.field_70759_as = entity.field_70177_z;
            living.field_70758_at = entity.field_70177_z;
        }
        Tuple<Double, Double> pitchYawTuple = VSMath.getPitchYawFromVector(new Vector3d(entityLook.x, entityLook.y, entityLook.z));
        entity.field_70125_A = ((Double)pitchYawTuple.func_76341_a()).floatValue();
        entity.field_70177_z = ((Double)pitchYawTuple.func_76340_b()).floatValue();
        if (entity instanceof EntityFireball) {
            EntityFireball ball = (EntityFireball)entity;
            ball.field_70232_b = entityMotion.x;
            ball.field_70233_c = entityMotion.y;
            ball.field_70230_d = entityMotion.z;
        }
        entity.field_70159_w = entityMotion.x;
        entity.field_70181_x = entityMotion.y;
        entity.field_70179_y = entityMotion.z;
        if (transformEntityBoundingBox) {
            AxisAlignedBB oldBB = entity.func_174813_aQ();
            Polygon newBBPoly = new Polygon(oldBB, transform);
            AxisAlignedBB newBB = newBBPoly.getEnclosedAABB();
            double oldBBSize = (oldBB.field_72336_d - oldBB.field_72340_a) * (oldBB.field_72337_e - oldBB.field_72338_b) * (oldBB.field_72334_f - oldBB.field_72339_c);
            double newBBSize = (newBB.field_72336_d - newBB.field_72340_a) * (newBB.field_72337_e - newBB.field_72338_b) * (newBB.field_72334_f - newBB.field_72339_c);
            double scaleFactor = Math.pow(oldBBSize / newBBSize, 0.3333333333333333);
            AxisAlignedBB newBBScaled = newBB.func_72314_b((scaleFactor - 1.0) * (newBB.field_72336_d - newBB.field_72340_a) / 2.0, (scaleFactor - 1.0) * (newBB.field_72337_e - newBB.field_72338_b) / 2.0, (scaleFactor - 1.0) * (newBB.field_72334_f - newBB.field_72339_c) / 2.0);
            entity.func_70107_b(entityPos.x, entityPos.y, entityPos.z);
            entity.func_174826_a(newBBScaled);
        } else {
            entity.func_70107_b(entityPos.x, entityPos.y, entityPos.z);
        }
    }

    @Nullable
    public static TileEntity getTileEntitySafe(World world, BlockPos pos) {
        return world.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
    }

    @Nullable
    public static ShipData getLastShipTouchedByEntity(Entity entity) {
        IDraggable asDraggable = (IDraggable)IDraggable.class.cast(entity);
        return asDraggable.getEntityShipMovementData().getLastTouchedShip();
    }

    @NonNull
    public static EntityShipMovementData getEntityShipMovementDataFor(Entity entity) {
        IDraggable asDraggable = (IDraggable)IDraggable.class.cast(entity);
        return asDraggable.getEntityShipMovementData();
    }

    private ValkyrienUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

