/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class VSMath {
    public static final int AABB_MERGE_PASSES = 5;
    public static final double STANDING_TOLERANCE = 0.42;

    public static Vector3d toVector3d(Vec3i vec) {
        return new Vector3d(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public static Vector3d toVector3d(Vec3d vec) {
        return new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static <T> List<T> generateLineBetween(Vec3d start, Vec3d end, IntTernaryFunction<T> constructor) {
        return VSMath.generateLineBetween((int)start.field_72450_a, (int)start.field_72448_b, (int)start.field_72449_c, (int)end.field_72450_a, (int)end.field_72448_b, (int)end.field_72449_c, constructor);
    }

    public static <T> List<T> generateLineBetween(int x1, int y1, int z1, int x2, int y2, int z2, IntTernaryFunction<T> constructor) {
        int zs;
        ArrayList<T> points = new ArrayList<T>();
        points.add(constructor.apply(x1, y1, z1));
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x2 > x1 ? 1 : -1;
        int ys = y2 > y1 ? 1 : -1;
        int n = zs = z2 > z1 ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                points.add(constructor.apply(x1, y1, z1));
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                points.add(constructor.apply(x1, y1, z1));
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                points.add(constructor.apply(x1, y1, z1));
            }
        }
        return points;
    }

    public static Tuple<Double, Double> getPitchYawFromVector(Vector3dc vector3dc) {
        double pitch = Math.toDegrees(-Math.asin(vector3dc.y()));
        if (Double.isNaN(pitch)) {
            if (vector3dc.y() > 0.0) {
                return new Tuple((Object)-90.0, (Object)0.0);
            }
            return new Tuple((Object)90.0, (Object)0.0);
        }
        double normalizeHorizontalComponents = -Math.cos(Math.toRadians(pitch));
        if (Math.abs(normalizeHorizontalComponents) < 1.0E-4 || Math.abs(vector3dc.x()) < 1.0E-4 && Math.abs(vector3dc.z()) < 1.0E-4) {
            return new Tuple((Object)pitch, (Object)0.0);
        }
        double yawFromRotVec = -Math.toDegrees(Math.atan2(vector3dc.x() / normalizeHorizontalComponents, vector3dc.z() / normalizeHorizontalComponents) + Math.PI);
        return new Tuple((Object)pitch, (Object)yawFromRotVec);
    }

    public static double[] getMinMaxOfArray(double[] elements) {
        double[] minMax = new double[2];
        minMax[0] = minMax[1] = elements[elements.length - 1];
        for (int i = elements.length - 2; i >= 0; --i) {
            minMax[0] = Math.min(minMax[0], elements[i]);
            minMax[1] = Math.max(minMax[1], elements[i]);
        }
        return minMax;
    }

    public static boolean canStandOnNormal(Vector3dc normal) {
        double radius = normal.x() * normal.x() + normal.z() * normal.z();
        return radius < 0.42;
    }

    public static void mergeAABBList(List<AxisAlignedBB> toFuse) {
        boolean changed = true;
        int passes = 0;
        while (changed && passes < 5) {
            changed = false;
            ++passes;
            for (int i = 0; i < toFuse.size(); ++i) {
                AxisAlignedBB bb = toFuse.get(i);
                for (int j = i + 1; j < toFuse.size(); ++j) {
                    AxisAlignedBB nextOne = toFuse.get(j);
                    if (!VSMath.connected(bb, nextOne)) continue;
                    AxisAlignedBB fused = VSMath.getFusedBoundingBox(bb, nextOne);
                    toFuse.remove(j);
                    toFuse.remove(i);
                    toFuse.add(fused);
                    j = toFuse.size();
                    changed = true;
                }
            }
        }
    }

    private static AxisAlignedBB getFusedBoundingBox(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        double mnX = bb1.field_72340_a;
        double mnY = bb1.field_72338_b;
        double mnZ = bb1.field_72339_c;
        double mxX = bb1.field_72336_d;
        double mxY = bb1.field_72337_e;
        double mxZ = bb1.field_72334_f;
        if (bb2.field_72340_a < mnX) {
            mnX = bb2.field_72340_a;
        }
        if (bb2.field_72338_b < mnY) {
            mnY = bb2.field_72338_b;
        }
        if (bb2.field_72339_c < mnZ) {
            mnZ = bb2.field_72339_c;
        }
        if (bb2.field_72336_d > mxX) {
            mxX = bb2.field_72336_d;
        }
        if (bb2.field_72337_e > mxY) {
            mxY = bb2.field_72337_e;
        }
        if (bb2.field_72334_f > mxZ) {
            mxZ = bb2.field_72334_f;
        }
        return new AxisAlignedBB(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }

    private static boolean connected(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.connectedInX(bb1, bb2) || VSMath.connectedInY(bb1, bb2) || VSMath.connectedInZ(bb1, bb2);
    }

    private static boolean connectedInX(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.intersectInX(bb1, bb2) && VSMath.areXAligned(bb1, bb2);
    }

    private static boolean connectedInY(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.intersectInY(bb1, bb2) && VSMath.areYAligned(bb1, bb2);
    }

    private static boolean connectedInZ(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.intersectInZ(bb1, bb2) && VSMath.areZAligned(bb1, bb2);
    }

    private static boolean intersectInX(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72336_d >= bb2.field_72340_a && bb1.field_72336_d < bb2.field_72336_d || bb1.field_72340_a > bb2.field_72340_a && bb1.field_72340_a <= bb2.field_72336_d;
    }

    private static boolean intersectInY(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72337_e >= bb2.field_72338_b && bb1.field_72337_e < bb2.field_72337_e || bb1.field_72338_b > bb2.field_72338_b && bb1.field_72338_b <= bb2.field_72337_e;
    }

    private static boolean intersectInZ(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72334_f >= bb2.field_72339_c && bb1.field_72334_f < bb2.field_72334_f || bb1.field_72339_c > bb2.field_72339_c && bb1.field_72339_c <= bb2.field_72334_f;
    }

    private static boolean areXAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72338_b == bb2.field_72338_b && bb1.field_72339_c == bb2.field_72339_c && bb1.field_72337_e == bb2.field_72337_e && bb1.field_72334_f == bb2.field_72334_f;
    }

    private static boolean areYAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a == bb2.field_72340_a && bb1.field_72339_c == bb2.field_72339_c && bb1.field_72336_d == bb2.field_72336_d && bb1.field_72334_f == bb2.field_72334_f;
    }

    private static boolean areZAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a == bb2.field_72340_a && bb1.field_72338_b == bb2.field_72338_b && bb1.field_72336_d == bb2.field_72336_d && bb1.field_72337_e == bb2.field_72337_e;
    }

    public static double interpolateModulatedNumbers(double prev, double current, double partialStep, double modulus) {
        double deltaBackward;
        double delta = current - prev;
        double deltaForward = VSMath.calculateRemainder(delta, modulus);
        double shortestDelta = deltaForward < -(deltaBackward = deltaForward - modulus) ? deltaForward : deltaBackward;
        double interpolatedButPossiblyNegative = prev + shortestDelta * partialStep;
        return VSMath.calculateRemainder(interpolatedButPossiblyNegative, modulus);
    }

    private static double calculateRemainder(double dividend, double divisor) {
        double remainder = dividend % divisor;
        if (remainder < 0.0) {
            remainder += divisor;
        }
        return remainder;
    }

    public static Matrix3dc createRotationMatrix(double pitchRadians, double yawRadians, double rollRadians) {
        return new Matrix3d().rotateXYZ(pitchRadians, yawRadians, rollRadians);
    }

    public static Quaterniondc createRotationQuat(double pitchRadians, double yawRadians, double rollRadians) {
        return VSMath.createRotationMatrix(pitchRadians, yawRadians, rollRadians).getNormalizedRotation(new Quaterniond());
    }

    private VSMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface IntTernaryFunction<T> {
        public T apply(int var1, int var2, int var3);
    }
}

