/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import org.joml.Vector2i;
import org.joml.Vector3i;

public class VSIterationUtils {
    public static void iterate3d(int startX, int startY, int startZ, int endX, int endY, int endZ, IntTernaryConsumer consumer) {
        int temp;
        if (startX > endX) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if (startY > endY) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        if (startZ > endZ) {
            temp = startZ;
            startZ = endZ;
            endZ = temp;
        }
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    consumer.accept(x, y, z);
                }
            }
        }
    }

    public static void expand3d(int originX, int originY, int originZ, IntTernaryConsumer consumer) {
        VSIterationUtils.expand3d(originX, originY, originZ, 1, consumer);
    }

    public static void expand3d(int originX, int originY, int originZ, int toExpand, IntTernaryConsumer consumer) {
        VSIterationUtils.iterate3d(originX - toExpand, originY - toExpand, originZ - toExpand, originX + toExpand, originY + toExpand, originZ + toExpand, consumer);
    }

    public static void iterate2d(int startX, int startY, int endX, int endY, IntBinaryConsumer consumer) {
        int temp;
        if (startX > endX) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if (startY > endY) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                consumer.accept(x, y);
            }
        }
    }

    public static void expand2d(int originX, int originY, IntBinaryConsumer consumer) {
        VSIterationUtils.expand2d(originX, originY, 1, consumer);
    }

    public static void expand2d(int originX, int originY, int toExpand, IntBinaryConsumer consumer) {
        VSIterationUtils.iterate2d(originX - toExpand, originY - toExpand, originX + toExpand, originY + toExpand, consumer);
    }

    public static void iterate3d(int startX, int startY, int startZ, int endX, int endY, int endZ, Consumer<? super BlockPos> consumer) {
        VSIterationUtils.iterate3d(startX, startY, startZ, endX, endY, endZ, (int x, int y, int z) -> consumer.accept(new BlockPos(x, y, z)));
    }

    @FunctionalInterface
    public static interface IntBinaryConsumer {
        public void accept(int var1, int var2);
    }

    @FunctionalInterface
    public static interface IntTernaryConsumer {
        public void accept(int var1, int var2, int var3);
    }

    public static class Int3dIterator
    implements Iterator<Vector3i> {
        int index = 0;
        final int startX;
        final int startY;
        final int startZ;
        final int maxX;
        final int maxY;
        final int maxZ;

        public Int3dIterator(int startX, int startY, int startZ, int endX, int endY, int endZ) {
            int temp;
            if (startX > endX) {
                temp = startX;
                startX = endX;
                endX = temp;
            }
            if (startY > endY) {
                temp = startY;
                startY = endY;
                endY = temp;
            }
            if (startZ > endZ) {
                temp = startZ;
                startZ = endZ;
                endZ = temp;
            }
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.maxX = endX + 1 - startX;
            this.maxY = endY + 1 - startY;
            this.maxZ = endZ + 1 - startZ;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.maxX * this.maxY * this.maxZ;
        }

        @Override
        public Vector3i next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int x = this.index % this.maxX;
            int y = this.index / this.maxX % this.maxY;
            int z = this.index / (this.maxX * this.maxY);
            ++this.index;
            return new Vector3i(x + this.startX, y + this.startY, z + this.startZ);
        }
    }

    public static class Int2dIterator
    implements Iterator<Vector2i> {
        int index = 0;
        final int startX;
        final int startY;
        final int maxX;
        final int maxY;

        public Int2dIterator(int startX, int startY, int endX, int endY) {
            int temp;
            if (startX > endX) {
                temp = startX;
                startX = endX;
                endX = temp;
            }
            if (startY > endY) {
                temp = startY;
                startY = endY;
                endY = temp;
            }
            this.startX = startX;
            this.startY = startY;
            this.maxX = endX + 1 - startX;
            this.maxY = endY + 1 - startY;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.maxX * this.maxY;
        }

        @Override
        public Vector2i next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int x = this.index % this.maxX;
            int y = this.index / this.maxY;
            ++this.index;
            return new Vector2i(x + this.startX, y + this.startY);
        }
    }
}

