/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.tileentity;

import java.util.Optional;
import java.util.UUID;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import org.valkyrienskies.mod.common.entity.EntityMountableChair;
import org.valkyrienskies.mod.common.ships.ship_transform.CoordinateSpaceType;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@MethodsReturnNonnullByDefault
public class TileEntityPassengerChair
extends TileEntity {
    private UUID chairEntityUUID = null;

    public void tryToMountPlayerToChair(EntityPlayer player, Vec3d mountPos) {
        boolean isChairEmpty;
        if (this.func_145831_w().field_72995_K) {
            throw new IllegalStateException("tryToMountPlayerToChair is not designed to be called on client side!");
        }
        if (this.chairEntityUUID != null) {
            Entity chairEntity = ((WorldServer)this.func_145831_w()).func_175733_a(this.chairEntityUUID);
            if (chairEntity != null) {
                if (chairEntity.field_70128_L || chairEntity.func_184207_aI()) {
                    this.chairEntityUUID = null;
                    this.func_70296_d();
                    isChairEmpty = true;
                } else {
                    isChairEmpty = false;
                }
            } else {
                this.chairEntityUUID = null;
                this.func_70296_d();
                isChairEmpty = true;
            }
        } else {
            isChairEmpty = true;
        }
        if (isChairEmpty) {
            Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(this.func_145831_w(), this.func_174877_v());
            CoordinateSpaceType mountCoordType = physicsObject.isPresent() ? CoordinateSpaceType.SUBSPACE_COORDINATES : CoordinateSpaceType.GLOBAL_COORDINATES;
            EntityMountableChair entityMountable = new EntityMountableChair(this.func_145831_w(), mountPos, mountCoordType, this.func_174877_v());
            this.chairEntityUUID = entityMountable.getPersistentID();
            this.func_70296_d();
            this.func_145831_w().func_72838_d((Entity)entityMountable);
            player.func_184220_m((Entity)entityMountable);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("has_chair_entity", this.chairEntityUUID != null);
        if (this.chairEntityUUID != null) {
            compound.func_186854_a("chair_entity_uuid", this.chairEntityUUID);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.chairEntityUUID = compound.func_74767_n("has_chair_entity") ? compound.func_186857_a("chair_entity_uuid") : null;
        super.func_145839_a(compound);
    }

    public void onBlockBroken(IBlockState state) {
        Entity chairEntity;
        if (this.chairEntityUUID != null && (chairEntity = ((WorldServer)this.func_145831_w()).func_175733_a(this.chairEntityUUID)) != null) {
            chairEntity.func_70106_y();
        }
    }

    public TileEntity createRelocatedTile(BlockPos newPos, ShipTransform transform, CoordinateSpaceType coordinateSpaceType) {
        TileEntityPassengerChair relocatedTile = new TileEntityPassengerChair();
        relocatedTile.func_145834_a(this.func_145831_w());
        relocatedTile.func_174878_a(newPos);
        if (this.chairEntityUUID != null) {
            EntityMountableChair chairEntity = (EntityMountableChair)((WorldServer)this.func_145831_w()).func_175733_a(this.chairEntityUUID);
            if (chairEntity != null) {
                Vec3d newMountPos = transform.transform(chairEntity.getMountPos(), TransformType.SUBSPACE_TO_GLOBAL);
                chairEntity.setMountValues(newMountPos, coordinateSpaceType, newPos);
            } else {
                this.chairEntityUUID = null;
            }
        }
        relocatedTile.chairEntityUUID = this.chairEntityUUID;
        this.chairEntityUUID = null;
        this.func_70296_d();
        return relocatedTile;
    }
}

