/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import org.joml.AxisAngle4d;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.block.BlockCaptainsChair;
import org.valkyrienskies.mod.common.piloting.ControllerInputType;
import org.valkyrienskies.mod.common.piloting.PilotControlsMessage;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.tileentity.TileEntityPilotableImpl;
import valkyrienwarfare.api.TransformType;

public class TileEntityCaptainsChair
extends TileEntityPilotableImpl {
    @Override
    public void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() == ValkyrienSkiesMod.INSTANCE.captainsChair) {
            PhysicsObject physicsObject = this.getParentPhysicsEntity();
            if (physicsObject != null) {
                this.processCalculationsForControlMessageAndApplyCalculations(physicsObject, message, blockState);
            }
        } else {
            this.setPilotEntity(null);
        }
    }

    @Override
    public ControllerInputType getControlInputType() {
        return ControllerInputType.CaptainsChair;
    }

    @Override
    public boolean setClientPilotingEntireShip() {
        return true;
    }

    @Override
    public final void onStartTileUsage() {
        this.getParentPhysicsEntity().getPhysicsCalculations().actAsArchimedes = true;
    }

    @Override
    public final void onStopTileUsage() {
        if (this.getParentPhysicsEntity() != null) {
            this.getParentPhysicsEntity().getPhysicsCalculations().actAsArchimedes = false;
        }
    }

    private void processCalculationsForControlMessageAndApplyCalculations(PhysicsObject controlledShip, PilotControlsMessage message, IBlockState state) {
        BlockPos chairPosition = this.func_174877_v();
        if (controlledShip.isShipAligningToGrid()) {
            return;
        }
        double pilotPitch = 0.0;
        double pilotYaw = ((BlockCaptainsChair)state.func_177230_c()).getChairYaw(state, chairPosition);
        double pilotRoll = 0.0;
        Matrix3d pilotRotationMatrix = new Matrix3d();
        pilotRotationMatrix.rotateXYZ(Math.toRadians(pilotPitch), Math.toRadians(pilotYaw), Math.toRadians(pilotRoll));
        Vector3d playerDirection = new Vector3d(1.0, 0.0, 0.0);
        pilotRotationMatrix.transform(playerDirection);
        Vector3d upDirection = new Vector3d(0.0, 1.0, 0.0);
        Vector3d downDirection = new Vector3d(0.0, -1.0, 0.0);
        Vector3d idealAngularDirection = new Vector3d();
        Vector3d idealLinearVelocity = new Vector3d();
        Vector3d shipUp = new Vector3d(0.0, 1.0, 0.0);
        Vector3d shipUpPosIdeal = new Vector3d(0.0, 1.0, 0.0);
        if (message.airshipForward_KeyDown) {
            idealLinearVelocity.add(playerDirection);
        }
        if (message.airshipBackward_KeyDown) {
            idealLinearVelocity.sub(playerDirection);
        }
        controlledShip.getShipTransformationManager().getCurrentTickTransform().transformDirection(idealLinearVelocity, TransformType.SUBSPACE_TO_GLOBAL);
        controlledShip.getShipTransformationManager().getCurrentTickTransform().transformDirection(shipUp, TransformType.SUBSPACE_TO_GLOBAL);
        if (message.airshipUp_KeyDown) {
            idealLinearVelocity.add(upDirection.mul(0.5, new Vector3d()));
        }
        if (message.airshipDown_KeyDown) {
            idealLinearVelocity.add(downDirection.mul(0.5, new Vector3d()));
        }
        double sidePitch = 0.0;
        if (message.airshipRight_KeyDown) {
            idealAngularDirection.sub(shipUp);
            sidePitch -= 10.0;
        }
        if (message.airshipLeft_KeyDown) {
            idealAngularDirection.add(shipUp);
            sidePitch += 10.0;
        }
        Vector3d sidesRotationAxis = new Vector3d(playerDirection);
        controlledShip.getShipTransformationManager().getCurrentTickTransform().transformDirection(sidesRotationAxis, TransformType.SUBSPACE_TO_GLOBAL);
        AxisAngle4d rotationSidesTransform = new AxisAngle4d(Math.toRadians(sidePitch), sidesRotationAxis.x, sidesRotationAxis.y, sidesRotationAxis.z);
        rotationSidesTransform.transform(shipUpPosIdeal);
        idealAngularDirection.mul(2.0);
        Vector3d shipUpRotationVector = shipUp.cross(shipUpPosIdeal, new Vector3d());
        double shipUpTheta = shipUp.angle(shipUpPosIdeal) + Math.PI;
        shipUpRotationVector.mul(shipUpTheta);
        idealAngularDirection.add(shipUpRotationVector);
        idealLinearVelocity.mul(20.0);
        if (message.airshipSprinting) {
            idealLinearVelocity.mul(2.0);
        }
        double lerpFactor = 0.2;
        Vector3d linearMomentumDif = controlledShip.getPhysicsCalculations().getLinearVelocity().sub(idealLinearVelocity, new Vector3d());
        Vector3d angularVelocityDif = controlledShip.getPhysicsCalculations().getAngularVelocity().sub(idealAngularDirection, new Vector3d());
        linearMomentumDif.mul(lerpFactor);
        angularVelocityDif.mul(lerpFactor);
        controlledShip.getPhysicsCalculations().getLinearVelocity().sub(linearMomentumDif);
        controlledShip.getPhysicsCalculations().getAngularVelocity().sub(angularVelocityDif);
    }
}

