/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.ship_world;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.physics.BlockPhysicsDetails;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.block_relocation.BlockFinder;
import org.valkyrienskies.mod.common.ships.block_relocation.IRelocationAwareTile;
import org.valkyrienskies.mod.common.ships.block_relocation.SpatialDetector;
import org.valkyrienskies.mod.common.ships.physics_data.BasicCenterOfMassProvider;
import org.valkyrienskies.mod.common.ships.ship_world.IPhysObjectWorld;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.ships.ship_world.WorldShipLoadingController;
import org.valkyrienskies.mod.common.util.multithreaded.CalledFromWrongThreadException;
import org.valkyrienskies.mod.common.util.multithreaded.VSWorldPhysicsLoop;

public class WorldServerShipManager
implements IPhysObjectWorld {
    private final WorldServer world;
    private final VSWorldPhysicsLoop physicsLoop;
    private final Thread physicsThread;
    private final WorldShipLoadingController loadingController;
    private final Map<UUID, PhysicsObject> loadedShips;
    private final LinkedHashSet<ImmutableTriple<BlockPos, ShipData, BlockFinder.BlockFinderType>> spawnQueue;
    private final LinkedHashSet<UUID> loadQueue;
    private final LinkedHashSet<UUID> unloadQueue;
    private final LinkedHashSet<UUID> backgroundLoadQueue;
    private final Set<UUID> loadingInBackground;
    private ImmutableList<PhysicsObject> threadSafeLoadedShips;

    public WorldServerShipManager(World world) {
        this.world = (WorldServer)world;
        this.physicsLoop = new VSWorldPhysicsLoop(world);
        this.loadingController = new WorldShipLoadingController(this);
        this.loadedShips = new HashMap<UUID, PhysicsObject>();
        this.spawnQueue = new LinkedHashSet();
        this.loadQueue = new LinkedHashSet();
        this.unloadQueue = new LinkedHashSet();
        this.backgroundLoadQueue = new LinkedHashSet();
        this.loadingInBackground = new HashSet<UUID>();
        this.threadSafeLoadedShips = ImmutableList.of();
        this.physicsThread = new Thread(this.physicsLoop);
        this.physicsThread.start();
    }

    private void enforceGameThread() {
        if (!this.world.func_152345_ab()) {
            throw new CalledFromWrongThreadException("Wrong thread calling code: " + Thread.currentThread());
        }
    }

    @Override
    public void onWorldUnload() {
        this.physicsLoop.kill();
    }

    @Override
    public PhysicsObject getPhysObjectFromUUID(@Nonnull UUID shipID) throws CalledFromWrongThreadException {
        this.enforceGameThread();
        return this.loadedShips.get(shipID);
    }

    @Override
    @Nonnull
    public List<PhysicsObject> getPhysObjectsInAABB(@Nonnull AxisAlignedBB toCheck) throws CalledFromWrongThreadException {
        this.enforceGameThread();
        ArrayList<PhysicsObject> nearby = new ArrayList<PhysicsObject>();
        for (PhysicsObject ship : this.getAllLoadedPhysObj()) {
            if (!toCheck.func_72326_a(ship.getShipBB())) continue;
            nearby.add(ship);
        }
        return nearby;
    }

    @Override
    public void tick() {
        Iterator<Map.Entry<UUID, PhysicsObject>> iterator = this.loadedShips.entrySet().iterator();
        while (iterator.hasNext()) {
            PhysicsObject physicsObject = iterator.next().getValue();
            if (!physicsObject.shouldShipBeDestroyed()) continue;
            physicsObject.destroyShip();
            QueryableShipData.get((World)this.world).removeShip(physicsObject.getShipData());
            iterator.remove();
        }
        this.spawnNewShips();
        this.loadingController.determineLoadAndUnload();
        this.loadAndUnloadShips();
        for (PhysicsObject ship : this.getAllLoadedPhysObj()) {
            ship.onTick();
        }
        this.loadingController.sendUpdatesToPlayers();
        this.threadSafeLoadedShips = ImmutableList.copyOf(this.loadedShips.values());
    }

    private void spawnNewShips() {
        for (ImmutableTriple immutableTriple : this.spawnQueue) {
            BlockPos physicsInfuserPos = (BlockPos)immutableTriple.getLeft();
            ShipData toSpawn = (ShipData)immutableTriple.getMiddle();
            BlockFinder.BlockFinderType blockBlockFinderType = (BlockFinder.BlockFinderType)((Object)immutableTriple.getRight());
            if (this.loadedShips.containsKey(toSpawn.getUuid())) {
                throw new IllegalStateException("Tried spawning a ShipData that was already loaded?\n" + toSpawn);
            }
            SpatialDetector detector = BlockFinder.getBlockFinderFor(blockBlockFinderType, physicsInfuserPos, (World)this.world, VSConfig.maxDetectedShipSize + 1, true);
            if (VSConfig.showAnnoyingDebugOutput) {
                System.out.println("Attempting to spawn " + toSpawn + " on the thread " + Thread.currentThread().getName());
            }
            if (detector.foundSet.size() > VSConfig.maxDetectedShipSize || detector.cleanHouse) {
                System.err.println("Ship too big or bedrock detected!");
                continue;
            }
            int radius = 7;
            ChunkPos centerPos = toSpawn.getChunkClaim().getCenterPos();
            for (int chunkX = -radius; chunkX <= radius; ++chunkX) {
                for (int chunkZ = -radius; chunkZ <= radius; ++chunkZ) {
                    toSpawn.getChunkClaim().addChunkClaim(centerPos.field_77276_a + chunkX, centerPos.field_77275_b + chunkZ);
                }
            }
            BasicCenterOfMassProvider centerOfMassProvider = new BasicCenterOfMassProvider();
            BlockPos.MutableBlockPos srcLocationPos = new BlockPos.MutableBlockPos();
            BlockPos centerDifference = toSpawn.getChunkClaim().getRegionCenter().func_177973_b((Vec3i)physicsInfuserPos);
            BlockPos.MutableBlockPos pasteLocationPos = new BlockPos.MutableBlockPos();
            HashMap<Long, Chunk> copiedChunksMap = new HashMap<Long, Chunk>();
            for (int hashedPos : detector.foundSet) {
                TileEntity pasteTile;
                SpatialDetector.setPosWithRespectTo(hashedPos, detector.firstBlock, srcLocationPos);
                pasteLocationPos.func_181079_c(srcLocationPos.func_177958_n() + centerDifference.func_177958_n(), srcLocationPos.func_177956_o() + centerDifference.func_177956_o(), srcLocationPos.func_177952_p() + centerDifference.func_177952_p());
                toSpawn.blockPositions.add(pasteLocationPos.func_177958_n(), pasteLocationPos.func_177956_o(), pasteLocationPos.func_177952_p());
                int newChunkX = pasteLocationPos.func_177958_n() >> 4;
                int newChunkZ = pasteLocationPos.func_177952_p() >> 4;
                long newChunkPosLong = ChunkPos.func_77272_a((int)newChunkX, (int)newChunkZ);
                if (!copiedChunksMap.containsKey(newChunkPosLong)) {
                    Chunk chunk = new Chunk((World)this.world, newChunkX, newChunkZ);
                    copiedChunksMap.put(newChunkPosLong, chunk);
                }
                Chunk chunkToSet = this.world.func_175726_f((BlockPos)srcLocationPos);
                Chunk newChunk = (Chunk)copiedChunksMap.get(newChunkPosLong);
                int storageIndex = srcLocationPos.func_177956_o() >> 4;
                if (storageIndex < 0 || storageIndex >= chunkToSet.field_76652_q.length) {
                    throw new IllegalStateException("Incorrect block copy!\n" + srcLocationPos);
                }
                IBlockState srcState = chunkToSet.field_76652_q[storageIndex].func_177485_a(srcLocationPos.func_177958_n() & 0xF, srcLocationPos.func_177956_o() & 0xF, srcLocationPos.func_177952_p() & 0xF);
                int newChunkStorageIndex = pasteLocationPos.func_177956_o() >> 4;
                if (newChunk.field_76652_q[newChunkStorageIndex] == Chunk.field_186036_a) {
                    newChunk.field_76652_q[newChunkStorageIndex] = new ExtendedBlockStorage(newChunkStorageIndex << 4, true);
                }
                newChunk.field_76652_q[newChunkStorageIndex].func_177484_a(pasteLocationPos.func_177958_n() & 0xF, pasteLocationPos.func_177956_o() & 0xF, pasteLocationPos.func_177952_p() & 0xF, srcState);
                if (BlockPhysicsDetails.isBlockProvidingForce(srcState)) {
                    toSpawn.activeForcePositions.add((BlockPos)pasteLocationPos);
                }
                centerOfMassProvider.onSetBlockState(toSpawn.getInertiaData(), (BlockPos)pasteLocationPos, Blocks.field_150350_a.func_176223_P(), srcState);
                TileEntity srcTile = this.world.func_175625_s((BlockPos)srcLocationPos);
                if (srcTile == null) continue;
                if (srcTile instanceof IRelocationAwareTile) {
                    pasteTile = ((IRelocationAwareTile)srcTile).createRelocatedTile((BlockPos)pasteLocationPos, toSpawn);
                } else {
                    NBTTagCompound tileEntNBT = srcTile.func_189515_b(new NBTTagCompound());
                    tileEntNBT.func_74768_a("x", pasteLocationPos.func_177958_n());
                    tileEntNBT.func_74768_a("y", pasteLocationPos.func_177956_o());
                    tileEntNBT.func_74768_a("z", pasteLocationPos.func_177952_p());
                    pasteTile = TileEntity.func_190200_a((World)this.world, (NBTTagCompound)tileEntNBT);
                }
                newChunk.func_150813_a(pasteTile);
            }
            for (Chunk chunk : copiedChunksMap.values()) {
                chunk.func_76603_b();
            }
            for (int hashedPos : detector.foundSet) {
                SpatialDetector.setPosWithRespectTo(hashedPos, detector.firstBlock, srcLocationPos);
                Chunk chunkToSet = this.world.func_175726_f((BlockPos)srcLocationPos);
                int storageIndex = srcLocationPos.func_177956_o() >> 4;
                if (storageIndex < 0 || storageIndex >= chunkToSet.field_76652_q.length) {
                    throw new IllegalStateException("Incorrect block copy!\n" + srcLocationPos);
                }
                IBlockState srcState = chunkToSet.field_76652_q[storageIndex].func_177485_a(srcLocationPos.func_177958_n() & 0xF, srcLocationPos.func_177956_o() & 0xF, srcLocationPos.func_177952_p() & 0xF);
                this.world.func_184138_a((BlockPos)srcLocationPos, srcState, Blocks.field_150350_a.func_176223_P(), 3);
                chunkToSet.field_76652_q[storageIndex].func_177484_a(srcLocationPos.func_177958_n() & 0xF, srcLocationPos.func_177956_o() & 0xF, srcLocationPos.func_177952_p() & 0xF, Blocks.field_150350_a.func_176223_P());
                this.world.func_175713_t((BlockPos)srcLocationPos);
                chunkToSet.func_76630_e();
            }
            HashSet<Long> chunksRelit = new HashSet<Long>();
            for (int hashedPos : detector.foundSet) {
                SpatialDetector.setPosWithRespectTo(hashedPos, detector.firstBlock, srcLocationPos);
                int changedChunkX = pasteLocationPos.func_177958_n() >> 4;
                int changedChunkZ = pasteLocationPos.func_177952_p() >> 4;
                long changedChunkPos = ChunkPos.func_77272_a((int)changedChunkX, (int)changedChunkZ);
                if (chunksRelit.contains(changedChunkPos)) continue;
                Chunk chunk = this.world.func_72964_e(changedChunkX, changedChunkZ);
                chunk.func_76603_b();
                chunk.func_150809_p();
                chunk.func_76630_e();
                chunksRelit.add(changedChunkPos);
            }
            toSpawn.getChunkClaim().forEach((x, z) -> {
                long chunkLong = ChunkPos.func_77272_a((int)x, (int)z);
                if (copiedChunksMap.containsKey(chunkLong)) {
                    this.injectChunkIntoWorldServer((Chunk)copiedChunksMap.get(chunkLong), (int)x, (int)z);
                } else {
                    this.injectChunkIntoWorldServer(new Chunk((World)this.world, x.intValue(), z.intValue()), (int)x, (int)z);
                }
            });
            QueryableShipData.get((World)this.world).addShip(toSpawn);
            PhysicsObject physicsObject = new PhysicsObject((World)this.world, toSpawn);
            this.loadedShips.put(toSpawn.getUuid(), physicsObject);
        }
        this.spawnQueue.clear();
    }

    private void injectChunkIntoWorldServer(@Nonnull Chunk chunk, int x, int z) {
        ChunkProviderServer provider = this.world.func_72863_F();
        provider.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
        chunk.func_76631_c();
        chunk.func_150809_p();
        chunk.func_76630_e();
    }

    private void loadAndUnloadShips() {
        ShipData toLoad;
        Optional<ShipData> toLoadOptional;
        QueryableShipData queryableShipData = QueryableShipData.get((World)this.world);
        for (UUID toLoadID : this.loadQueue) {
            toLoadOptional = queryableShipData.getShip(toLoadID);
            if (!toLoadOptional.isPresent()) {
                throw new IllegalStateException("No ship found for ID:\n" + toLoadID);
            }
            toLoad = toLoadOptional.get();
            if (this.loadedShips.containsKey(toLoadID)) {
                throw new IllegalStateException("Tried loading a ShipData that was already loaded?\n" + toLoad);
            }
            this.loadingInBackground.remove(toLoadID);
            if (VSConfig.showAnnoyingDebugOutput) {
                System.out.println("Attempting to load ship " + toLoad);
            }
            PhysicsObject physicsObject = new PhysicsObject((World)this.world, toLoad);
            PhysicsObject old = this.loadedShips.put(toLoad.getUuid(), physicsObject);
            if (old == null) continue;
            throw new IllegalStateException("How did we already have a ship loaded for " + toLoad);
        }
        this.loadQueue.clear();
        for (UUID toLoadID : this.backgroundLoadQueue) {
            if (this.loadingInBackground.contains(toLoadID)) continue;
            if (this.loadedShips.containsKey(toLoadID)) {
                throw new IllegalStateException("Tried loading a ShipData that was already loaded? Ship ID is\n" + toLoadID);
            }
            toLoadOptional = queryableShipData.getShip(toLoadID);
            if (!toLoadOptional.isPresent()) {
                throw new IllegalStateException("No ship found for ID:\n" + toLoadID);
            }
            toLoad = toLoadOptional.get();
            this.loadingInBackground.add(toLoadID);
            if (VSConfig.showAnnoyingDebugOutput) {
                System.out.println("Attempting to load " + toLoad + " in the background.");
            }
            ChunkProviderServer chunkProviderServer = this.world.func_72863_F();
            for (ChunkPos chunkPos : toLoad.getChunkClaim()) {
                Runnable returnTask = () -> {
                    if (VSConfig.showAnnoyingDebugOutput) {
                        System.out.println("Loaded ship chunk " + chunkPos);
                    }
                };
                chunkProviderServer.loadChunk(chunkPos.field_77276_a, chunkPos.field_77275_b, returnTask);
            }
        }
        this.backgroundLoadQueue.clear();
        for (UUID toUnloadID : this.unloadQueue) {
            if (!this.loadedShips.containsKey(toUnloadID)) {
                throw new IllegalStateException("Tried unloading a ShipData that isn't loaded? Ship ID is\n" + toUnloadID);
            }
            PhysicsObject physicsObject = this.getPhysObjectFromUUID(toUnloadID);
            if (VSConfig.showAnnoyingDebugOutput) {
                System.out.println("Attempting to unload " + physicsObject);
            }
            physicsObject.unload();
            boolean success = this.loadedShips.remove(toUnloadID, physicsObject);
            if (success) continue;
            throw new IllegalStateException("How did we fail to unload " + physicsObject.getShipData());
        }
        this.unloadQueue.clear();
    }

    @Override
    @Nonnull
    public Iterable<PhysicsObject> getAllLoadedPhysObj() throws CalledFromWrongThreadException {
        this.enforceGameThread();
        return this.loadedShips.values();
    }

    @Override
    @Nonnull
    public ImmutableList<PhysicsObject> getAllLoadedThreadSafe() {
        return this.threadSafeLoadedShips;
    }

    public void queueShipSpawn(@Nonnull ShipData data, @Nonnull BlockPos spawnPos, @Nonnull BlockFinder.BlockFinderType blockFinderType) {
        this.enforceGameThread();
        this.spawnQueue.add((ImmutableTriple<BlockPos, ShipData, BlockFinder.BlockFinderType>)ImmutableTriple.of((Object)spawnPos, (Object)data, (Object)((Object)blockFinderType)));
    }

    @Override
    public void queueShipLoad(@Nonnull UUID shipID) {
        this.enforceGameThread();
        this.loadQueue.add(shipID);
    }

    @Override
    public void queueShipUnload(@Nonnull UUID shipID) {
        this.enforceGameThread();
        this.unloadQueue.add(shipID);
    }

    public void queueShipLoadBackground(@Nonnull UUID shipID) {
        this.enforceGameThread();
        this.backgroundLoadQueue.add(shipID);
    }

    public Iterable<Long> getBackgroundShipChunks() throws CalledFromWrongThreadException {
        this.enforceGameThread();
        ArrayList<Long> backgroundChunks = new ArrayList<Long>();
        QueryableShipData queryableShipData = QueryableShipData.get((World)this.world);
        for (UUID shipID : this.loadingInBackground) {
            Optional<ShipData> shipDataOptional = queryableShipData.getShip(shipID);
            if (!shipDataOptional.isPresent()) {
                throw new IllegalStateException("Ship data not present for:\n" + shipID);
            }
            backgroundChunks.addAll(shipDataOptional.get().getChunkClaim().getClaimedChunks());
        }
        return backgroundChunks;
    }

    public WorldServer getWorld() {
        return this.world;
    }

    public VSWorldPhysicsLoop getPhysicsLoop() {
        return this.physicsLoop;
    }
}

