/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.ship_world;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.ship_world.IPhysObjectWorld;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.multithreaded.CalledFromWrongThreadException;

public class WorldClientShipManager
implements IPhysObjectWorld {
    private final World world;
    private final Map<UUID, PhysicsObject> loadedShips;
    private final LinkedHashSet<UUID> loadQueue;
    private final LinkedHashSet<UUID> unloadQueue;
    private ImmutableList<PhysicsObject> threadSafeLoadedShips;
    private static final Logger logger = LogManager.getLogger();

    public WorldClientShipManager(World world) {
        this.world = world;
        this.loadedShips = new HashMap<UUID, PhysicsObject>();
        this.loadQueue = new LinkedHashSet();
        this.unloadQueue = new LinkedHashSet();
        this.threadSafeLoadedShips = ImmutableList.of();
    }

    private void enforceGameThread() throws CalledFromWrongThreadException {
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            throw new CalledFromWrongThreadException("Wrong thread calling code: " + Thread.currentThread());
        }
    }

    @Override
    public void tick() {
        this.loadAndUnloadShips();
        for (PhysicsObject physicsObject : this.getAllLoadedPhysObj()) {
            physicsObject.onTick();
        }
        this.threadSafeLoadedShips = ImmutableList.copyOf(this.loadedShips.values());
    }

    private void loadAndUnloadShips() {
        QueryableShipData queryableShipData = QueryableShipData.get(this.world);
        for (UUID toLoadID : this.loadQueue) {
            if (this.loadedShips.containsKey(toLoadID)) {
                logger.error("Tried loading a for ship that was already loaded? UUID is\n" + toLoadID);
                continue;
            }
            Optional<ShipData> toLoadOptional = queryableShipData.getShip(toLoadID);
            if (!toLoadOptional.isPresent()) {
                logger.error("No ship found for UUID:\n" + toLoadID);
                continue;
            }
            ShipData shipData = toLoadOptional.get();
            PhysicsObject physicsObject = new PhysicsObject(this.world, shipData);
            for (Chunk chunk : physicsObject.getClaimedChunkCache()) {
                chunk.field_76636_d = true;
            }
            this.loadedShips.put(toLoadID, physicsObject);
            if (!VSConfig.showAnnoyingDebugOutput) continue;
            System.out.println("Successfully loaded " + shipData);
        }
        this.loadQueue.clear();
        for (UUID toUnloadID : this.unloadQueue) {
            if (!this.loadedShips.containsKey(toUnloadID)) {
                logger.error("Tried unloading that isn't loaded? ID is\n" + toUnloadID);
                continue;
            }
            PhysicsObject removedShip = this.loadedShips.get(toUnloadID);
            removedShip.unload();
            this.loadedShips.remove(toUnloadID);
            if (!VSConfig.showAnnoyingDebugOutput) continue;
            System.out.println("Successfully unloaded " + removedShip.getShipData());
        }
        this.unloadQueue.clear();
    }

    @Override
    public void onWorldUnload() {
        this.loadedShips.clear();
    }

    @Override
    @Nullable
    public PhysicsObject getPhysObjectFromUUID(@Nonnull UUID shipID) throws CalledFromWrongThreadException {
        this.enforceGameThread();
        return this.loadedShips.get(shipID);
    }

    @Override
    @Nonnull
    public List<PhysicsObject> getPhysObjectsInAABB(@Nonnull AxisAlignedBB toCheck) throws CalledFromWrongThreadException {
        this.enforceGameThread();
        ArrayList<PhysicsObject> nearby = new ArrayList<PhysicsObject>();
        for (PhysicsObject physicsObject : this.getAllLoadedPhysObj()) {
            if (!toCheck.func_72326_a(physicsObject.getShipBB())) continue;
            nearby.add(physicsObject);
        }
        return nearby;
    }

    @Override
    @Nonnull
    public Iterable<PhysicsObject> getAllLoadedPhysObj() throws CalledFromWrongThreadException {
        this.enforceGameThread();
        return this.loadedShips.values();
    }

    @Override
    @Nonnull
    public ImmutableList<PhysicsObject> getAllLoadedThreadSafe() {
        return this.threadSafeLoadedShips;
    }

    @Override
    public void queueShipLoad(@Nonnull UUID shipID) {
        this.enforceGameThread();
        this.loadQueue.add(shipID);
    }

    @Override
    public void queueShipUnload(@Nonnull UUID shipID) {
        this.enforceGameThread();
        this.unloadQueue.add(shipID);
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.world;
    }
}

