/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.ship_world;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.entity.EntityMountable;
import org.valkyrienskies.mod.common.ships.ship_transform.CoordinateSpaceType;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@ParametersAreNonnullByDefault
public class VSWorldEventListener
implements IWorldEventListener {
    private final World worldObj;

    public VSWorldEventListener(World world) {
        this.worldObj = world;
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entity) {
        World world = this.worldObj;
        BlockPos posAt = new BlockPos(entity);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(world, posAt);
        if (!this.worldObj.field_72995_K && physicsObject.isPresent() && !(entity instanceof EntityFallingBlock)) {
            if (entity instanceof EntityArmorStand || entity instanceof EntityPig || entity instanceof EntityBoat) {
                EntityMountable entityMountable = new EntityMountable(world, entity.func_174791_d(), CoordinateSpaceType.SUBSPACE_COORDINATES, posAt);
                world.func_72838_d((Entity)entityMountable);
                entity.func_184220_m((Entity)entityMountable);
            }
            world.func_72964_e(entity.func_180425_c().func_177958_n() >> 4, entity.func_180425_c().func_177952_p() >> 4).func_76622_b(entity);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(entity, TransformType.SUBSPACE_TO_GLOBAL, false);
            world.func_72964_e(entity.func_180425_c().func_177958_n() >> 4, entity.func_180425_c().func_177952_p() >> 4).func_76612_a(entity);
        }
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        if (!this.worldObj.field_72995_K) {
            for (EntityPlayer entityplayermp : this.worldObj.field_73010_i) {
                if (entityplayermp == null || entityplayermp.func_145782_y() == breakerId) continue;
                Vector3d posVector = new Vector3d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(this.worldObj, pos);
                physicsObject.ifPresent(object -> object.getShipTransformationManager().getCurrentTickTransform().transformPosition(posVector, TransformType.SUBSPACE_TO_GLOBAL));
                double d0 = posVector.x - entityplayermp.field_70165_t;
                double d1 = posVector.y - entityplayermp.field_70163_u;
                double d2 = posVector.z - entityplayermp.field_70161_v;
                if (!(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
                ((EntityPlayerMP)entityplayermp).field_71135_a.func_147359_a((Packet)new SPacketBlockBreakAnim(breakerId, pos, progress));
            }
        }
    }

    public void func_190570_a(int p_190570_1_, boolean p_190570_2_, boolean p_190570_3_, double p_190570_4_, double p_190570_6_, double p_190570_8_, double p_190570_10_, double p_190570_12_, double p_190570_14_, int ... p_190570_16_) {
    }
}

