/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.ship_world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.client.render.PhysObjectRenderManager;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.physics.IPhysicsBlockController;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.block_relocation.MoveBlocks;
import org.valkyrienskies.mod.common.ships.chunk_claims.ClaimedChunkCacheController;
import org.valkyrienskies.mod.common.ships.chunk_claims.SurroundingChunkCacheController;
import org.valkyrienskies.mod.common.ships.chunk_claims.VSChunkClaim;
import org.valkyrienskies.mod.common.ships.interpolation.ITransformInterpolator;
import org.valkyrienskies.mod.common.ships.interpolation.SimpleEMATransformInterpolator;
import org.valkyrienskies.mod.common.ships.physics_data.ShipInertiaData;
import org.valkyrienskies.mod.common.ships.physics_data.ShipPhysicsData;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransformationManager;
import org.valkyrienskies.mod.common.util.datastructures.IBlockPosSet;
import org.valkyrienskies.mod.common.util.datastructures.IBlockPosSetAABB;
import valkyrienwarfare.api.IPhysicsEntity;
import valkyrienwarfare.api.TransformType;

public class PhysicsObject
implements IPhysicsEntity {
    private static final int DISABLE_PHYSICS_FOR_X_INITIAL_TICKS = 20;
    public static int TICKS_SINCE_TELEPORT_TO_START_DRAGGING = 50;
    private final List<EntityPlayerMP> watchingPlayers;
    private final Set<IPhysicsBlockController> physicsControllers;
    private final Set<IPhysicsBlockController> physicsControllersImmutable;
    private final PhysObjectRenderManager shipRenderer;
    private final BlockPos referenceBlockPos;
    private final ShipTransformationManager shipTransformationManager;
    private final PhysicsCalculations physicsCalculations;
    private final SurroundingChunkCacheController cachedSurroundingChunks;
    private final ClaimedChunkCacheController claimedChunkCache;
    private final World world;
    private final ShipData shipData;
    private final ITransformInterpolator transformInterpolator;
    private boolean shipAligningToGrid;
    @Nonnull
    private DeconstructState deconstructState;
    private boolean forceToUseShipDataTransform;
    private int ticksSinceShipTeleport;
    private int ticksExisted;

    PhysicsObject(World world, ShipData initial) {
        this.world = world;
        this.shipData = initial;
        this.referenceBlockPos = this.getShipData().getChunkClaim().getRegionCenter();
        this.watchingPlayers = new ArrayList<EntityPlayerMP>();
        this.physicsControllers = ConcurrentHashMap.newKeySet();
        this.physicsControllersImmutable = Collections.unmodifiableSet(this.physicsControllers);
        this.claimedChunkCache = new ClaimedChunkCacheController(this);
        this.cachedSurroundingChunks = new SurroundingChunkCacheController(this);
        this.shipTransformationManager = new ShipTransformationManager(this, this.getShipData().getShipTransform());
        this.physicsCalculations = new PhysicsCalculations(this);
        this.shipAligningToGrid = false;
        this.deconstructState = DeconstructState.NOT_DECONSTRUCTING;
        this.forceToUseShipDataTransform = false;
        this.ticksSinceShipTeleport = TICKS_SINCE_TELEPORT_TO_START_DRAGGING + 1;
        this.ticksExisted = 0;
        if (world.field_72995_K) {
            this.shipRenderer = new PhysObjectRenderManager(this, this.referenceBlockPos);
            this.transformInterpolator = new SimpleEMATransformInterpolator(initial.getShipTransform(), initial.getShipBB(), 0.5);
        } else {
            this.shipRenderer = null;
            this.getShipTransformationManager().updateAllTransforms(this.getShipData().getShipTransform(), true, true);
            this.transformInterpolator = null;
        }
    }

    void onTick() {
        if (!this.world.field_72995_K) {
            this.cachedSurroundingChunks.updateChunkCache();
            boolean forceToUseShipDataTransformLocalCopy = this.forceToUseShipDataTransform;
            this.forceToUseShipDataTransform = false;
            if (forceToUseShipDataTransformLocalCopy) {
                ShipTransform forcedTransform = this.shipData.getShipTransform();
                this.getShipTransformationManager().setPrevPhysicsTransform(forcedTransform);
                this.getShipTransformationManager().setCurrentPhysicsTransform(forcedTransform);
                this.getShipTransformationManager().setPrevTickTransform(forcedTransform);
                this.getShipTransformationManager().setCurrentTickTransform(forcedTransform);
            }
            ++this.ticksSinceShipTeleport;
            ShipTransform physicsTransform = this.getShipTransformationManager().getCurrentPhysicsTransform();
            this.getShipTransformationManager().updateAllTransforms(physicsTransform, false, true);
            this.getShipData().setShipTransform(this.getShipTransformationManager().getCurrentTickTransform());
            this.getShipData().setPrevTickShipTransform(this.getShipTransformationManager().getPrevTickTransform());
        } else {
            this.transformInterpolator.tickTransformInterpolator();
            ShipTransform newTransform = this.transformInterpolator.getCurrentTickTransform();
            AxisAlignedBB newAABB = this.transformInterpolator.getCurrentAABB();
            this.shipData.setPrevTickShipTransform(this.shipData.getShipTransform());
            this.shipData.setShipTransform(newTransform);
            this.shipData.setShipBB(newAABB);
            this.shipTransformationManager.updateAllTransforms(newTransform, false, false);
        }
        ++this.ticksExisted;
    }

    public ChunkCache getCachedSurroundingChunks() {
        return this.cachedSurroundingChunks.getCachedChunks();
    }

    public void onSetTileEntity(BlockPos pos, TileEntity tileentity) {
        if (tileentity instanceof IPhysicsBlockController) {
            this.physicsControllers.add((IPhysicsBlockController)tileentity);
        }
    }

    public void onRemoveTileEntity(BlockPos pos) {
        this.physicsControllers.removeIf(next -> next.getNodePos().equals((Object)pos));
    }

    public Set<IPhysicsBlockController> getPhysicsControllersInShip() {
        return this.physicsControllersImmutable;
    }

    boolean shouldShipBeDestroyed() {
        if (this.getBlockPositions().isEmpty()) {
            return true;
        }
        if (this.deconstructState.deconstructShip) {
            if (this.deconstructState.mustBeAlignedBeforeDeconstruct) {
                return this.isShipAlignedToWorld();
            }
            return true;
        }
        return false;
    }

    public boolean isShipAlignedToWorld() {
        Quaterniond shipQuat = this.getShipTransformationManager().getCurrentTickTransform().rotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        return Math.toDegrees(shipQuat.angle()) < 2.0;
    }

    void destroyShip() {
        ArrayList<EntityPlayerMP> watchersCopy = new ArrayList<EntityPlayerMP>(this.getWatchingPlayers());
        for (ChunkPos chunkPos : this.getChunkClaim()) {
            SPacketUnloadChunk unloadPacket = new SPacketUnloadChunk(chunkPos.field_77276_a, chunkPos.field_77275_b);
            for (EntityPlayerMP entityPlayerMP : watchersCopy) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)unloadPacket);
            }
        }
        this.getWatchingPlayers().clear();
        if (!this.getBlockPositions().isEmpty()) {
            if (this.deconstructState.copyBlocks) {
                BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
                ShipTransform currentTransform = this.getShipTransformationManager().getCurrentTickTransform();
                Vector3d position = new Vector3d(currentTransform.getPosX(), currentTransform.getPosY(), currentTransform.getPosZ());
                BlockPos centerDifference = new BlockPos((double)Math.round(this.getCenterCoord().x() - position.x()), (double)Math.round(this.getCenterCoord().y() - position.y()), (double)Math.round(this.getCenterCoord().z() - position.z()));
                for (BlockPos oldPos : this.getBlockPositions()) {
                    newPos.func_181079_c(oldPos.func_177958_n() - centerDifference.func_177958_n(), oldPos.func_177956_o() - centerDifference.func_177956_o(), oldPos.func_177952_p() - centerDifference.func_177952_p());
                    MoveBlocks.copyBlockToPos(this.getWorld(), oldPos, (BlockPos)newPos, null);
                }
                HashSet<Long> hashSet = new HashSet<Long>();
                for (BlockPos changedPos : this.getBlockPositions()) {
                    int changedChunkZ;
                    int changedChunkX = changedPos.func_177958_n() - centerDifference.func_177958_n() >> 4;
                    long changedChunkPos = ChunkPos.func_77272_a((int)changedChunkX, (int)(changedChunkZ = changedPos.func_177952_p() - centerDifference.func_177952_p() >> 4));
                    if (hashSet.contains(changedChunkPos)) continue;
                    Chunk chunk = this.world.func_72964_e(changedChunkX, changedChunkZ);
                    chunk.func_76603_b();
                    chunk.func_150809_p();
                    chunk.func_76630_e();
                    hashSet.add(changedChunkPos);
                }
            }
            for (BlockPos oldPos : this.getBlockPositions()) {
                this.getWorld().func_175713_t(oldPos);
            }
        }
        this.getClaimedChunkCache().deleteShipChunksFromWorld();
    }

    public Vector3dc getCenterCoord() {
        return this.getShipData().getShipTransform().getCenterCoord();
    }

    @Override
    public Vec3d rotateVector(Vec3d vector, TransformType transformType) {
        return this.getShipTransformationManager().getCurrentTickTransform().rotate(vector, transformType);
    }

    @Override
    public Vec3d transformVector(Vec3d vector, TransformType transformType) {
        return this.getShipTransformationManager().getCurrentTickTransform().transform(vector, transformType);
    }

    public Chunk getChunkAt(int chunkX, int chunkZ) {
        return this.claimedChunkCache.getChunkAt(chunkX, chunkZ);
    }

    public AxisAlignedBB getShipBoundingBox() {
        return this.getShipData().getShipBB();
    }

    public void setShipBoundingBox(AxisAlignedBB shipBoundingBox) {
        this.getShipData().setShipBB(shipBoundingBox);
    }

    void unload() {
        this.watchingPlayers.clear();
        if (!this.getWorld().field_72995_K) {
            ChunkProviderServer provider = (ChunkProviderServer)this.getWorld().func_72863_F();
            for (ChunkPos chunkPos : this.getChunkClaim()) {
                provider.func_189549_a(this.claimedChunkCache.getChunkAt(chunkPos.field_77276_a, chunkPos.field_77275_b));
            }
        } else {
            ChunkProviderClient provider = (ChunkProviderClient)this.getWorld().func_72863_F();
            for (ChunkPos chunkPos : this.getChunkClaim()) {
                provider.func_73234_b(chunkPos.field_77276_a, chunkPos.field_77275_b);
            }
            this.getShipRenderer().killRenderers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateChunk(@Nonnull Chunk chunk) {
        if (!this.getChunkClaim().containsChunk(chunk.field_76635_g, chunk.field_76647_h)) {
            throw new IllegalStateException("Ship " + this.getShipData() + " does not contain chunk " + chunk);
        }
        if (this.claimedChunkCache == null) {
            throw new IllegalStateException("Claimed chunk cache was null for ship " + this.getShipData());
        }
        if (this.shipRenderer == null) {
            throw new IllegalStateException("Ship renderer was null for ship " + this.getShipData());
        }
        this.claimedChunkCache.updateChunk(chunk);
        this.shipRenderer.updateChunk(chunk);
    }

    public AxisAlignedBB getPhysicsTransformAABB() {
        AxisAlignedBB subspaceBB = this.getBlockPositions().makeAABB();
        if (subspaceBB == null) {
            return null;
        }
        subspaceBB = subspaceBB.func_72321_a(1.0, 1.0, 1.0);
        Polygon largerPoly = new Polygon(subspaceBB, this.getShipTransformationManager().getCurrentPhysicsTransform(), TransformType.SUBSPACE_TO_GLOBAL);
        AxisAlignedBB worldBB = largerPoly.getEnclosedAABB();
        return worldBB;
    }

    public boolean isPhysicsReady() {
        return this.ticksExisted >= 20;
    }

    @Nullable
    public TileEntity getShipTile(@Nonnull BlockPos pos) {
        Chunk chunk = this.claimedChunkCache.getChunkAt(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk != null) {
            return chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return null;
    }

    public List<EntityPlayerMP> getWatchingPlayers() {
        return this.watchingPlayers;
    }

    public PhysObjectRenderManager getShipRenderer() {
        return this.shipRenderer;
    }

    public BlockPos getReferenceBlockPos() {
        return this.referenceBlockPos;
    }

    public ShipTransformationManager getShipTransformationManager() {
        return this.shipTransformationManager;
    }

    public PhysicsCalculations getPhysicsCalculations() {
        return this.physicsCalculations;
    }

    public ClaimedChunkCacheController getClaimedChunkCache() {
        return this.claimedChunkCache;
    }

    public World getWorld() {
        return this.world;
    }

    public ShipData getShipData() {
        return this.shipData;
    }

    public ITransformInterpolator getTransformInterpolator() {
        return this.transformInterpolator;
    }

    public void setShipAligningToGrid(boolean shipAligningToGrid) {
        this.shipAligningToGrid = shipAligningToGrid;
    }

    public boolean isShipAligningToGrid() {
        return this.shipAligningToGrid;
    }

    public void setDeconstructState(@Nonnull DeconstructState deconstructState) {
        if (deconstructState == null) {
            throw new NullPointerException("deconstructState is marked non-null but is null");
        }
        this.deconstructState = deconstructState;
    }

    @Nonnull
    public DeconstructState getDeconstructState() {
        return this.deconstructState;
    }

    public void setForceToUseShipDataTransform(boolean forceToUseShipDataTransform) {
        this.forceToUseShipDataTransform = forceToUseShipDataTransform;
    }

    public void setTicksSinceShipTeleport(int ticksSinceShipTeleport) {
        this.ticksSinceShipTeleport = ticksSinceShipTeleport;
    }

    public int getTicksSinceShipTeleport() {
        return this.ticksSinceShipTeleport;
    }

    public ShipData setName(String name) {
        return this.getShipData().setName(name);
    }

    public ShipPhysicsData getPhysicsData() {
        return this.getShipData().getPhysicsData();
    }

    public ShipInertiaData getInertiaData() {
        return this.getShipData().getInertiaData();
    }

    public IBlockPosSetAABB getBlockPositions() {
        return this.getShipData().getBlockPositions();
    }

    public IBlockPosSet getActiveForcePositions() {
        return this.getShipData().getActiveForcePositions();
    }

    public ShipTransform getShipTransform() {
        return this.getShipData().getShipTransform();
    }

    public ShipTransform getPrevTickShipTransform() {
        return this.getShipData().getPrevTickShipTransform();
    }

    public AxisAlignedBB getShipBB() {
        return this.getShipData().getShipBB();
    }

    public boolean isPhysicsEnabled() {
        return this.getShipData().isPhysicsEnabled();
    }

    public VSChunkClaim getChunkClaim() {
        return this.getShipData().getChunkClaim();
    }

    public UUID getUuid() {
        return this.getShipData().getUuid();
    }

    public String getName() {
        return this.getShipData().getName();
    }

    public void setShipTransform(ShipTransform shipTransform) {
        this.getShipData().setShipTransform(shipTransform);
    }

    public void setPrevTickShipTransform(ShipTransform prevTickShipTransform) {
        this.getShipData().setPrevTickShipTransform(prevTickShipTransform);
    }

    public void setShipBB(AxisAlignedBB shipBB) {
        this.getShipData().setShipBB(shipBB);
    }

    public void setPhysicsEnabled(boolean physicsEnabled) {
        this.getShipData().setPhysicsEnabled(physicsEnabled);
    }

    public static enum DeconstructState {
        NOT_DECONSTRUCTING(false, false, false),
        DECONSTRUCT_NORMAL(true, true, true),
        DECONSTRUCT_IMMEDIATE_NO_COPY(true, false, false);

        private final boolean deconstructShip;
        private final boolean copyBlocks;
        private final boolean mustBeAlignedBeforeDeconstruct;

        private DeconstructState(boolean deconstructShip, boolean copyBlocks, boolean mustBeAlignedBeforeDeconstruct) {
            this.deconstructShip = deconstructShip;
            this.copyBlocks = copyBlocks;
            this.mustBeAlignedBeforeDeconstruct = mustBeAlignedBeforeDeconstruct;
        }

        public boolean isDeconstructShip() {
            return this.deconstructShip;
        }

        public boolean isCopyBlocks() {
            return this.copyBlocks;
        }

        public boolean isMustBeAlignedBeforeDeconstruct() {
            return this.mustBeAlignedBeforeDeconstruct;
        }
    }
}

