/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.ship_transform;

import net.minecraft.util.math.AxisAlignedBB;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class ShipTransformationManager {
    private final PhysicsObject parent;
    public Vector3dc[] normals;
    private ShipTransform currentTickTransform;
    private ShipTransform renderTransform;
    private ShipTransform prevTickTransform;
    private ShipTransform currentPhysicsTransform;
    private ShipTransform prevPhysicsTransform;

    public ShipTransformationManager(PhysicsObject parent, ShipTransform initialTransform) {
        this.parent = parent;
        this.currentTickTransform = initialTransform;
        this.renderTransform = initialTransform;
        this.prevTickTransform = initialTransform;
        this.currentPhysicsTransform = initialTransform;
        this.prevPhysicsTransform = initialTransform;
        this.normals = ShipTransformationManager.createCollisionNormals(initialTransform);
    }

    private static Vector3dc[] createCollisionNormals(ShipTransform transform) {
        int i;
        Vector3dc[] newNormals = new Vector3dc[15];
        Vector3d[] alignedNorms = Polygon.generateAxisAlignedNorms();
        Vector3dc[] rotatedNorms = ShipTransformationManager.generateRotationNormals(transform);
        for (int i2 = 0; i2 < 6; ++i2) {
            Vector3dc currentNorm = i2 < 3 ? alignedNorms[i2] : rotatedNorms[i2 - 3];
            newNormals[i2] = currentNorm;
        }
        int cont = 6;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Vector3d norm = newNormals[i].cross(newNormals[j + 3], new Vector3d());
                norm.normalize();
                newNormals[cont] = norm;
                ++cont;
            }
        }
        for (i = 0; i < newNormals.length; ++i) {
            if (!(newNormals[i].lengthSquared() < 0.01)) continue;
            newNormals[i] = new Vector3d(0.0, 1.0, 0.0);
        }
        newNormals[0] = new Vector3d(1.0, 0.0, 0.0);
        newNormals[1] = new Vector3d(0.0, 1.0, 0.0);
        newNormals[2] = new Vector3d(0.0, 0.0, 1.0);
        return newNormals;
    }

    private static Vector3dc[] generateRotationNormals(ShipTransform shipTransform) {
        Vector3dc[] norms = Polygon.generateAxisAlignedNorms();
        for (int i = 0; i < 3; ++i) {
            shipTransform.transformDirection((Vector3d)norms[i], TransformType.SUBSPACE_TO_GLOBAL);
        }
        return norms;
    }

    @Deprecated
    public void updateAllTransforms(ShipTransform newTransform, boolean updatePhysicsTransform, boolean updateParentAABB) {
        this.prevTickTransform = this.currentTickTransform;
        this.currentTickTransform = newTransform;
        if (this.parent.getWorld().field_72995_K) {
            updateParentAABB = false;
        }
        if (this.prevTickTransform == null) {
            this.prevTickTransform = this.currentTickTransform;
        }
        if (updatePhysicsTransform) {
            this.parent.getPhysicsCalculations().generatePhysicsTransform();
            this.prevPhysicsTransform = this.currentPhysicsTransform;
        }
        if (updateParentAABB) {
            this.updateParentAABB();
        }
        this.normals = ShipTransformationManager.createCollisionNormals(this.currentTickTransform);
    }

    private void updateParentAABB() {
        AxisAlignedBB subspaceBB = this.parent.getBlockPositions().makeAABB();
        if (subspaceBB == null) {
            return;
        }
        subspaceBB = subspaceBB.func_72321_a(1.0, 1.0, 1.0);
        Polygon largerPoly = new Polygon(subspaceBB, this.getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
        AxisAlignedBB worldBB = largerPoly.getEnclosedAABB();
        this.parent.setShipBoundingBox(worldBB);
    }

    public ShipTransform getCurrentTickTransform() {
        return this.currentTickTransform;
    }

    public ShipTransform getRenderTransform() {
        if (!this.parent.getWorld().field_72995_K || this.renderTransform == null) {
            return this.currentTickTransform;
        }
        return this.renderTransform;
    }

    public ShipTransform getPrevTickTransform() {
        return this.prevTickTransform;
    }

    public ShipTransform getCurrentPhysicsTransform() {
        return this.currentPhysicsTransform;
    }

    public ShipTransform getPrevPhysicsTransform() {
        return this.prevPhysicsTransform;
    }

    public void updatePreviousPhysicsTransform() {
        this.prevPhysicsTransform = this.currentPhysicsTransform;
    }

    public void updateRenderTransform(double partialTick) {
        if (partialTick == 0.0) {
            this.renderTransform = this.prevTickTransform;
            return;
        }
        if (partialTick == 1.0) {
            this.renderTransform = this.currentTickTransform;
            return;
        }
        ShipTransform prev = this.prevTickTransform;
        ShipTransform cur = this.currentTickTransform;
        Vector3dc shipCenter = this.parent.getCenterCoord();
        Vector3d prevPos = new Vector3d(shipCenter);
        Vector3d curPos = new Vector3d(shipCenter);
        prev.transformPosition(prevPos, TransformType.SUBSPACE_TO_GLOBAL);
        cur.transformPosition(curPos, TransformType.SUBSPACE_TO_GLOBAL);
        Vector3d deltaPos = curPos.sub(prevPos, new Vector3d());
        deltaPos.mul(partialTick);
        Vector3d partialPos = new Vector3d(prevPos);
        partialPos.add(deltaPos);
        Quaterniond prevRot = prev.rotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaterniond curRot = cur.rotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaterniond partialRot = prevRot.slerp(curRot, partialTick, new Quaterniond()).normalize();
        this.renderTransform = new ShipTransform(partialPos.x, partialPos.y, partialPos.z, partialRot, this.parent.getCenterCoord());
    }

    public void setCurrentTickTransform(ShipTransform currentTickTransform) {
        this.currentTickTransform = currentTickTransform;
    }

    public void setPrevTickTransform(ShipTransform prevTickTransform) {
        this.prevTickTransform = prevTickTransform;
    }

    public void setCurrentPhysicsTransform(ShipTransform currentPhysicsTransform) {
        this.currentPhysicsTransform = currentPhysicsTransform;
    }

    public void setPrevPhysicsTransform(ShipTransform prevPhysicsTransform) {
        this.prevPhysicsTransform = prevPhysicsTransform;
    }
}

