/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.ship_transform;

import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienNBTUtils;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Immutable
public class ShipTransform {
    private static final Logger log = LogManager.getLogger(ShipTransform.class);
    @JsonDeserialize(as=Matrix4d.class)
    private final Matrix4dc subspaceToGlobal;
    @JsonDeserialize(as=Matrix4d.class)
    private final Matrix4dc globalToSubspace;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final Vector3dc centerCoord;

    public ShipTransform(Vector3dc position, Vector3dc centerCoord) {
        this(position.x(), position.y(), position.z(), new Quaterniond(), centerCoord);
    }

    public ShipTransform(Vector3dc position, Quaterniondc rotation, Vector3dc centerCoord) {
        this(position.x(), position.y(), position.z(), rotation, centerCoord);
    }

    public ShipTransform(double posX, double posY, double posZ, Quaterniondc rotation, Vector3dc centerCoord) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.centerCoord = centerCoord;
        this.subspaceToGlobal = new Matrix4d().translate(posX, posY, posZ).rotate(rotation).translate(-centerCoord.x(), -centerCoord.y(), -centerCoord.z());
        this.globalToSubspace = this.subspaceToGlobal.invert(new Matrix4d());
    }

    public BlockPos getShipPositionBlockPos() {
        return new BlockPos(this.getPosX(), this.getPosY(), this.getPosZ());
    }

    public Vec3d getShipPositionVec3d() {
        return new Vec3d(this.getPosX(), this.getPosY(), this.getPosZ());
    }

    public static Matrix4d createTransform(ShipTransform prev, ShipTransform current) {
        return current.subspaceToGlobal.mul(prev.globalToSubspace, new Matrix4d());
    }

    public Vector3d transformPositionNew(Vector3d position, TransformType transformType) {
        return this.getTransformMatrix(transformType).transformPosition(position);
    }

    public Vector3d transformDirectionNew(Vector3d direction, TransformType transformType) {
        return this.getTransformMatrix(transformType).transformDirection(direction);
    }

    public void transformPosition(Vector3d position, TransformType transformType) {
        this.getTransformMatrix(transformType).transformPosition(position);
    }

    public void transformDirection(Vector3d direction, TransformType transformType) {
        this.getTransformMatrix(transformType).transformDirection(direction);
    }

    public Vec3d transform(Vec3d vec3d, TransformType transformType) {
        Vector3d vec3dAsVector = JOML.convert(vec3d);
        this.transformPosition(vec3dAsVector, transformType);
        return JOML.toMinecraft(vec3dAsVector);
    }

    public Vec3d rotate(Vec3d vec3d, TransformType transformType) {
        Vector3d vec3dAsVector = new Vector3d(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        this.transformDirection(vec3dAsVector, transformType);
        return new Vec3d(vec3dAsVector.x, vec3dAsVector.y, vec3dAsVector.z);
    }

    public BlockPos transform(BlockPos pos, TransformType transformType) {
        Vector3d blockPosAsVector = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        this.transformPosition(blockPosAsVector, transformType);
        return new BlockPos(blockPosAsVector.x - 0.5, blockPosAsVector.y - 0.5, blockPosAsVector.z - 0.5);
    }

    public Quaterniond rotationQuaternion(TransformType transformType) {
        return this.getTransformMatrix(transformType).getNormalizedRotation(new Quaterniond());
    }

    public void writeToNBT(NBTTagCompound compound, String name) {
        compound.func_74773_a(name, ValkyrienNBTUtils.toByteArray(this.subspaceToGlobal.get(new double[16])));
    }

    public Matrix3dc createRotationMatrix(TransformType transformType) {
        return this.getTransformMatrix(transformType).get3x3(new Matrix3d());
    }

    @Deprecated
    public Matrix4dc getTransformMatrix(TransformType transformType) {
        switch (transformType) {
            case SUBSPACE_TO_GLOBAL: {
                return this.subspaceToGlobal;
            }
            case GLOBAL_TO_SUBSPACE: {
                return this.globalToSubspace;
            }
        }
        throw new IllegalArgumentException("Unexpected TransformType Enum: " + (Object)((Object)transformType));
    }

    public void transform(Entity player, TransformType globalToSubspace, boolean transformEntityBoundingBox) {
        ValkyrienUtils.transformEntity(this.getTransformMatrix(globalToSubspace), player, transformEntityBoundingBox);
    }

    public static ShipTransformBuilder builder() {
        return new ShipTransformBuilder();
    }

    public ShipTransformBuilder toBuilder() {
        return new ShipTransformBuilder().subspaceToGlobal(this.subspaceToGlobal).globalToSubspace(this.globalToSubspace).posX(this.posX).posY(this.posY).posZ(this.posZ).centerCoord(this.centerCoord);
    }

    public Matrix4dc getSubspaceToGlobal() {
        return this.subspaceToGlobal;
    }

    public Matrix4dc getGlobalToSubspace() {
        return this.globalToSubspace;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public Vector3dc getCenterCoord() {
        return this.centerCoord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShipTransform)) {
            return false;
        }
        ShipTransform other = (ShipTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Matrix4dc this$subspaceToGlobal = this.getSubspaceToGlobal();
        Matrix4dc other$subspaceToGlobal = other.getSubspaceToGlobal();
        if (this$subspaceToGlobal == null ? other$subspaceToGlobal != null : !this$subspaceToGlobal.equals(other$subspaceToGlobal)) {
            return false;
        }
        Matrix4dc this$globalToSubspace = this.getGlobalToSubspace();
        Matrix4dc other$globalToSubspace = other.getGlobalToSubspace();
        if (this$globalToSubspace == null ? other$globalToSubspace != null : !this$globalToSubspace.equals(other$globalToSubspace)) {
            return false;
        }
        if (Double.compare(this.getPosX(), other.getPosX()) != 0) {
            return false;
        }
        if (Double.compare(this.getPosY(), other.getPosY()) != 0) {
            return false;
        }
        if (Double.compare(this.getPosZ(), other.getPosZ()) != 0) {
            return false;
        }
        Vector3dc this$centerCoord = this.getCenterCoord();
        Vector3dc other$centerCoord = other.getCenterCoord();
        return !(this$centerCoord == null ? other$centerCoord != null : !this$centerCoord.equals(other$centerCoord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShipTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Matrix4dc $subspaceToGlobal = this.getSubspaceToGlobal();
        result = result * 59 + ($subspaceToGlobal == null ? 43 : $subspaceToGlobal.hashCode());
        Matrix4dc $globalToSubspace = this.getGlobalToSubspace();
        result = result * 59 + ($globalToSubspace == null ? 43 : $globalToSubspace.hashCode());
        long $posX = Double.doubleToLongBits(this.getPosX());
        result = result * 59 + (int)($posX >>> 32 ^ $posX);
        long $posY = Double.doubleToLongBits(this.getPosY());
        result = result * 59 + (int)($posY >>> 32 ^ $posY);
        long $posZ = Double.doubleToLongBits(this.getPosZ());
        result = result * 59 + (int)($posZ >>> 32 ^ $posZ);
        Vector3dc $centerCoord = this.getCenterCoord();
        result = result * 59 + ($centerCoord == null ? 43 : $centerCoord.hashCode());
        return result;
    }

    public String toString() {
        return "ShipTransform(subspaceToGlobal=" + this.getSubspaceToGlobal() + ", globalToSubspace=" + this.getGlobalToSubspace() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ", centerCoord=" + this.getCenterCoord() + ")";
    }

    public ShipTransform withSubspaceToGlobal(Matrix4dc subspaceToGlobal) {
        return this.subspaceToGlobal == subspaceToGlobal ? this : new ShipTransform(subspaceToGlobal, this.globalToSubspace, this.posX, this.posY, this.posZ, this.centerCoord);
    }

    public ShipTransform withGlobalToSubspace(Matrix4dc globalToSubspace) {
        return this.globalToSubspace == globalToSubspace ? this : new ShipTransform(this.subspaceToGlobal, globalToSubspace, this.posX, this.posY, this.posZ, this.centerCoord);
    }

    public ShipTransform withPosX(double posX) {
        return this.posX == posX ? this : new ShipTransform(this.subspaceToGlobal, this.globalToSubspace, posX, this.posY, this.posZ, this.centerCoord);
    }

    public ShipTransform withPosY(double posY) {
        return this.posY == posY ? this : new ShipTransform(this.subspaceToGlobal, this.globalToSubspace, this.posX, posY, this.posZ, this.centerCoord);
    }

    public ShipTransform withPosZ(double posZ) {
        return this.posZ == posZ ? this : new ShipTransform(this.subspaceToGlobal, this.globalToSubspace, this.posX, this.posY, posZ, this.centerCoord);
    }

    public ShipTransform withCenterCoord(Vector3dc centerCoord) {
        return this.centerCoord == centerCoord ? this : new ShipTransform(this.subspaceToGlobal, this.globalToSubspace, this.posX, this.posY, this.posZ, centerCoord);
    }

    public ShipTransform(Matrix4dc subspaceToGlobal, Matrix4dc globalToSubspace, double posX, double posY, double posZ, Vector3dc centerCoord) {
        this.subspaceToGlobal = subspaceToGlobal;
        this.globalToSubspace = globalToSubspace;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.centerCoord = centerCoord;
    }

    private ShipTransform() {
        this.subspaceToGlobal = null;
        this.globalToSubspace = null;
        this.posX = 0.0;
        this.posY = 0.0;
        this.posZ = 0.0;
        this.centerCoord = null;
    }

    public static class ShipTransformBuilder {
        private Matrix4dc subspaceToGlobal;
        private Matrix4dc globalToSubspace;
        private double posX;
        private double posY;
        private double posZ;
        private Vector3dc centerCoord;

        ShipTransformBuilder() {
        }

        public ShipTransformBuilder subspaceToGlobal(Matrix4dc subspaceToGlobal) {
            this.subspaceToGlobal = subspaceToGlobal;
            return this;
        }

        public ShipTransformBuilder globalToSubspace(Matrix4dc globalToSubspace) {
            this.globalToSubspace = globalToSubspace;
            return this;
        }

        public ShipTransformBuilder posX(double posX) {
            this.posX = posX;
            return this;
        }

        public ShipTransformBuilder posY(double posY) {
            this.posY = posY;
            return this;
        }

        public ShipTransformBuilder posZ(double posZ) {
            this.posZ = posZ;
            return this;
        }

        public ShipTransformBuilder centerCoord(Vector3dc centerCoord) {
            this.centerCoord = centerCoord;
            return this;
        }

        public ShipTransform build() {
            return new ShipTransform(this.subspaceToGlobal, this.globalToSubspace, this.posX, this.posY, this.posZ, this.centerCoord);
        }

        public String toString() {
            return "ShipTransform.ShipTransformBuilder(subspaceToGlobal=" + this.subspaceToGlobal + ", globalToSubspace=" + this.globalToSubspace + ", posX=" + this.posX + ", posY=" + this.posY + ", posZ=" + this.posZ + ", centerCoord=" + this.centerCoord + ")";
        }
    }
}

