/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.physics_data;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import org.joml.Matrix3d;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.physics.BlockPhysicsDetails;
import org.valkyrienskies.mod.common.ships.physics_data.IPhysicsObjectCenterOfMassProvider;
import org.valkyrienskies.mod.common.ships.physics_data.ShipInertiaData;

public class BasicCenterOfMassProvider
implements IPhysicsObjectCenterOfMassProvider {
    private static final double INERTIA_OFFSET = 0.4;

    @Override
    public void onSetBlockState(ShipInertiaData inertiaData, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (!newState.equals(oldState)) {
            double oldMass = BlockPhysicsDetails.getMassFromState(oldState);
            double newMass = BlockPhysicsDetails.getMassFromState(newState);
            double deltaMass = newMass - oldMass;
            if (Math.abs(deltaMass) > 1.0E-5) {
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.5;
                double z = (double)pos.func_177952_p() + 0.5;
                this.addMassAt(inertiaData, x, y, z, deltaMass /= 9.0);
                this.addMassAt(inertiaData, x + 0.4, y + 0.4, z + 0.4, deltaMass);
                this.addMassAt(inertiaData, x + 0.4, y + 0.4, z - 0.4, deltaMass);
                this.addMassAt(inertiaData, x + 0.4, y - 0.4, z + 0.4, deltaMass);
                this.addMassAt(inertiaData, x + 0.4, y - 0.4, z - 0.4, deltaMass);
                this.addMassAt(inertiaData, x - 0.4, y + 0.4, z + 0.4, deltaMass);
                this.addMassAt(inertiaData, x - 0.4, y + 0.4, z - 0.4, deltaMass);
                this.addMassAt(inertiaData, x - 0.4, y - 0.4, z + 0.4, deltaMass);
                this.addMassAt(inertiaData, x - 0.4, y - 0.4, z - 0.4, deltaMass);
            }
        }
    }

    private void addMassAt(ShipInertiaData inertiaData, double x, double y, double z, double addedMass) {
        double[] gameMoITensor = new double[9];
        Matrix3d transposed = inertiaData.getGameMoITensor().transpose(new Matrix3d());
        transposed.get(gameMoITensor);
        double gameTickMass = inertiaData.getGameTickMass();
        Vector3d prevCenterOfMass = new Vector3d(inertiaData.getGameTickCenterOfMass());
        if (gameTickMass > 1.0E-4) {
            Vector3d newCenterOfMass = inertiaData.getGameTickCenterOfMass().mul(gameTickMass, new Vector3d());
            newCenterOfMass.add(x * addedMass, y * addedMass, z * addedMass);
            newCenterOfMass.mul(1.0 / (gameTickMass + addedMass));
            inertiaData.setGameTickCenterOfMass(newCenterOfMass);
        } else {
            inertiaData.setGameTickCenterOfMass(new Vector3d(x, y, z));
            inertiaData.setGameMoITensor(new Matrix3d().zero());
        }
        double cmShiftX = prevCenterOfMass.x - inertiaData.getGameTickCenterOfMass().x();
        double cmShiftY = prevCenterOfMass.y - inertiaData.getGameTickCenterOfMass().y();
        double cmShiftZ = prevCenterOfMass.z - inertiaData.getGameTickCenterOfMass().z();
        double rx = x - inertiaData.getGameTickCenterOfMass().x();
        double ry = y - inertiaData.getGameTickCenterOfMass().y();
        double rz = z - inertiaData.getGameTickCenterOfMass().z();
        gameMoITensor[0] = gameMoITensor[0] + (cmShiftY * cmShiftY + cmShiftZ * cmShiftZ) * gameTickMass + (ry * ry + rz * rz) * addedMass;
        gameMoITensor[1] = gameMoITensor[1] - cmShiftX * cmShiftY * gameTickMass - rx * ry * addedMass;
        gameMoITensor[2] = gameMoITensor[2] - cmShiftX * cmShiftZ * gameTickMass - rx * rz * addedMass;
        gameMoITensor[3] = gameMoITensor[1];
        gameMoITensor[4] = gameMoITensor[4] + (cmShiftX * cmShiftX + cmShiftZ * cmShiftZ) * gameTickMass + (rx * rx + rz * rz) * addedMass;
        gameMoITensor[5] = gameMoITensor[5] - cmShiftY * cmShiftZ * gameTickMass - ry * rz * addedMass;
        gameMoITensor[6] = gameMoITensor[2];
        gameMoITensor[7] = gameMoITensor[5];
        gameMoITensor[8] = gameMoITensor[8] + (cmShiftX * cmShiftX + cmShiftY * cmShiftY) * gameTickMass + (rx * rx + ry * ry) * addedMass;
        inertiaData.setGameMoITensor(new Matrix3d().set(gameMoITensor).transpose());
        if (inertiaData.getGameTickMass() + addedMass < 1.0E-4) {
            inertiaData.setGameTickMass(0.0);
        } else {
            inertiaData.setGameTickMass(inertiaData.getGameTickMass() + addedMass);
        }
    }
}

