/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.interpolation;

import javax.annotation.Nonnull;
import net.minecraft.util.math.AxisAlignedBB;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.ships.interpolation.ITransformInterpolator;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import valkyrienwarfare.api.TransformType;

public class SimpleEMATransformInterpolator
implements ITransformInterpolator {
    @Nonnull
    private ShipTransform curTickTransform;
    @Nonnull
    private ShipTransform latestReceivedTransform;
    @Nonnull
    private AxisAlignedBB latestRecievedAABB;
    private final double filterAlpha;
    private static final double DOUBLE_EQUALS_THRESHOLD = 1.0E-6;

    public SimpleEMATransformInterpolator(@Nonnull ShipTransform initial, @Nonnull AxisAlignedBB initialAABB, double filterAlpha) {
        this.curTickTransform = initial;
        this.latestReceivedTransform = initial;
        this.latestRecievedAABB = initialAABB;
        this.filterAlpha = filterAlpha;
    }

    @Override
    public void onNewTransformPacket(@Nonnull ShipTransform newTransform, @Nonnull AxisAlignedBB newAABB) {
        this.latestReceivedTransform = newTransform;
        this.latestRecievedAABB = newAABB;
    }

    @Override
    public void tickTransformInterpolator() {
        Vector3d curPos = new Vector3d(this.curTickTransform.getPosX(), this.curTickTransform.getPosY(), this.curTickTransform.getPosZ());
        if (!this.latestReceivedTransform.getCenterCoord().equals(this.curTickTransform.getCenterCoord(), 1.0E-6)) {
            Vector3d offset = this.latestReceivedTransform.getCenterCoord().sub(this.curTickTransform.getCenterCoord(), new Vector3d());
            this.curTickTransform.transformDirection(offset, TransformType.SUBSPACE_TO_GLOBAL);
            curPos = curPos.add(offset, new Vector3d());
        }
        Vector3d latestDataPos = new Vector3d(this.latestReceivedTransform.getPosX(), this.latestReceivedTransform.getPosY(), this.latestReceivedTransform.getPosZ());
        Vector3d newPos = curPos.lerp(latestDataPos, this.filterAlpha, new Vector3d());
        Quaterniond curRot = this.curTickTransform.rotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaterniond latestDataRot = this.latestReceivedTransform.rotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaterniond newRot = curRot.slerp(latestDataRot, this.filterAlpha, new Quaterniond()).normalize();
        this.curTickTransform = new ShipTransform(newPos, newRot, this.latestReceivedTransform.getCenterCoord());
    }

    @Override
    @Nonnull
    public ShipTransform getCurrentTickTransform() {
        return this.curTickTransform;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getCurrentAABB() {
        Matrix4d latestToCurrent = this.curTickTransform.getSubspaceToGlobal().mul(this.latestReceivedTransform.getGlobalToSubspace(), new Matrix4d());
        Polygon latestBB = new Polygon(this.latestRecievedAABB, latestToCurrent);
        return latestBB.getEnclosedAABB();
    }
}

