/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.chunk_claims;

import lombok.NonNull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mod.common.ships.chunk_claims.VSChunkClaim;

@NonNull
public class ShipChunkAllocator {
    private static final Logger log = LogManager.getLogger(ShipChunkAllocator.class);
    public static final int MAX_CHUNK_LENGTH = 3200;
    public static final int MAX_CHUNK_RADIUS = 1599;
    public static final int CHUNK_X_START = 320000;
    public static final int CHUNK_Z_START = 0;
    private int lastChunkX = 320000;
    private int lastChunkZ = 0;

    public static boolean isChunkInShipyard(int chunkX, int chunkZ) {
        return chunkX >= 318401 && chunkZ >= -1599;
    }

    public static boolean isChunkInShipyard(ChunkPos pos) {
        return ShipChunkAllocator.isChunkInShipyard(pos.field_77276_a, pos.field_77275_b);
    }

    public static boolean isBlockInShipyard(BlockPos pos) {
        return ShipChunkAllocator.isChunkInShipyard(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public VSChunkClaim allocateNextChunkClaim() {
        return new VSChunkClaim(new ChunkPos(this.lastChunkX, this.lastChunkZ += 3200));
    }

    public int getLastChunkX() {
        return this.lastChunkX;
    }

    public int getLastChunkZ() {
        return this.lastChunkZ;
    }
}

