/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.mod.common.physics.BlockPhysicsDetails;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.physics_data.BasicCenterOfMassProvider;
import org.valkyrienskies.mod.common.ships.physics_data.IPhysicsObjectCenterOfMassProvider;

@ParametersAreNonnullByDefault
public final class ShipDataMethods {
    private static final IPhysicsObjectCenterOfMassProvider centerOfMassProvider = new BasicCenterOfMassProvider();

    public static void onSetBlockState(ShipData shipData, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (!shipData.getChunkClaim().containsBlock(pos)) {
            throw new IllegalArgumentException("Get onSetBlockState() called for pos " + pos + ", but this ISN'T a part of the ship " + shipData);
        }
        if (newState.equals(Blocks.field_150350_a.func_176223_P())) {
            shipData.getBlockPositions().remove(pos);
        } else {
            shipData.getBlockPositions().add(pos);
        }
        if (BlockPhysicsDetails.isBlockProvidingForce(newState)) {
            shipData.activeForcePositions.add(pos);
        } else {
            shipData.activeForcePositions.remove(pos);
        }
        centerOfMassProvider.onSetBlockState(shipData.getInertiaData(), pos, oldState, newState);
    }

    private ShipDataMethods() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

