/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.MultiValueAttribute;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.util.math.AxisAlignedBB;
import org.joml.Vector3d;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.valkyrienskies.mod.common.ships.chunk_claims.VSChunkClaim;
import org.valkyrienskies.mod.common.ships.physics_data.ShipInertiaData;
import org.valkyrienskies.mod.common.ships.physics_data.ShipPhysicsData;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.util.cqengine.ConcurrentUpdatableIndexedCollection;
import org.valkyrienskies.mod.common.util.datastructures.IBlockPosSet;
import org.valkyrienskies.mod.common.util.datastructures.IBlockPosSetAABB;
import org.valkyrienskies.mod.common.util.datastructures.SmallBlockPosSet;
import org.valkyrienskies.mod.common.util.datastructures.SmallBlockPosSetAABB;
import org.valkyrienskies.mod.common.util.jackson.annotations.PacketIgnore;

public class ShipData {
    private final transient ConcurrentUpdatableIndexedCollection<ShipData> owner;
    private final ShipPhysicsData physicsData;
    private final ShipInertiaData inertiaData;
    @PacketIgnore
    @Nullable
    @JsonSerialize(as=SmallBlockPosSetAABB.class)
    @JsonDeserialize(as=SmallBlockPosSetAABB.class)
    public IBlockPosSetAABB blockPositions;
    @PacketIgnore
    @Nullable
    @JsonSerialize(as=SmallBlockPosSet.class)
    @JsonDeserialize(as=SmallBlockPosSet.class)
    public IBlockPosSet activeForcePositions;
    private ShipTransform shipTransform;
    private ShipTransform prevTickShipTransform;
    private AxisAlignedBB shipBB;
    private boolean physicsEnabled;
    private final VSChunkClaim chunkClaim;
    private final UUID uuid;
    private String name;
    public static final Attribute<ShipData, String> NAME = QueryFactory.nullableAttribute(ShipData::getName);
    public static final Attribute<ShipData, UUID> UUID = QueryFactory.attribute(ShipData::getUuid);
    public static final Attribute<ShipData, Long> CHUNKS = new MultiValueAttribute<ShipData, Long>(){

        @Override
        public Set<Long> getValues(ShipData physo, QueryOptions queryOptions) {
            return physo.getChunkClaim().getClaimedChunks();
        }
    };

    private ShipData(@NonNull ConcurrentUpdatableIndexedCollection<ShipData> owner, ShipPhysicsData physicsData, @Nonnull ShipInertiaData inertiaData, @NonNull ShipTransform shipTransform, @NonNull ShipTransform prevTickShipTransform, @NonNull AxisAlignedBB shipBB, boolean physicsEnabled, @NonNull VSChunkClaim chunkClaim, @NonNull UUID uuid, @NonNull String name) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (shipTransform == null) {
            throw new NullPointerException("shipTransform is marked non-null but is null");
        }
        if (prevTickShipTransform == null) {
            throw new NullPointerException("prevTickShipTransform is marked non-null but is null");
        }
        if (shipBB == null) {
            throw new NullPointerException("shipBB is marked non-null but is null");
        }
        if (chunkClaim == null) {
            throw new NullPointerException("chunkClaim is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.owner = owner;
        this.physicsData = physicsData;
        this.inertiaData = inertiaData;
        this.shipTransform = shipTransform;
        this.prevTickShipTransform = prevTickShipTransform;
        this.shipBB = shipBB;
        this.physicsEnabled = physicsEnabled;
        this.chunkClaim = chunkClaim;
        this.uuid = uuid;
        this.name = name;
        this.blockPositions = new SmallBlockPosSetAABB(chunkClaim.getCenterPos().func_180334_c(), 0, chunkClaim.getCenterPos().func_180333_d(), 1024, 1024, 1024);
        this.activeForcePositions = new SmallBlockPosSet(chunkClaim.getCenterPos().func_180334_c(), chunkClaim.getCenterPos().func_180333_d());
    }

    public static ShipData createData(ConcurrentUpdatableIndexedCollection<ShipData> owner, String name, VSChunkClaim chunkClaim, UUID shipID, ShipTransform shipTransform, AxisAlignedBB aabb) {
        return new ShipData(owner, new ShipPhysicsData(new Vector3d(), new Vector3d()), new ShipInertiaData(), shipTransform, shipTransform, aabb, false, chunkClaim, shipID, name);
    }

    public ShipData setName(String name) {
        this.name = name;
        this.owner.updateObjectIndices(this, NAME);
        return this;
    }

    public ShipPhysicsData getPhysicsData() {
        return this.physicsData;
    }

    public ShipInertiaData getInertiaData() {
        return this.inertiaData;
    }

    @Nullable
    public IBlockPosSetAABB getBlockPositions() {
        return this.blockPositions;
    }

    @Nullable
    public IBlockPosSet getActiveForcePositions() {
        return this.activeForcePositions;
    }

    public ShipTransform getShipTransform() {
        return this.shipTransform;
    }

    public ShipTransform getPrevTickShipTransform() {
        return this.prevTickShipTransform;
    }

    public AxisAlignedBB getShipBB() {
        return this.shipBB;
    }

    public boolean isPhysicsEnabled() {
        return this.physicsEnabled;
    }

    public VSChunkClaim getChunkClaim() {
        return this.chunkClaim;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    private ShipData() {
        this.owner = null;
        this.physicsData = null;
        this.inertiaData = null;
        this.chunkClaim = null;
        this.uuid = null;
    }

    public void setShipTransform(ShipTransform shipTransform) {
        this.shipTransform = shipTransform;
    }

    public void setPrevTickShipTransform(ShipTransform prevTickShipTransform) {
        this.prevTickShipTransform = prevTickShipTransform;
    }

    public void setShipBB(AxisAlignedBB shipBB) {
        this.shipBB = shipBB;
    }

    public void setPhysicsEnabled(boolean physicsEnabled) {
        this.physicsEnabled = physicsEnabled;
    }
}

