/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.network;

import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.valkyrienskies.mod.common.network.ShipTransformUpdateMessage;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.interpolation.ITransformInterpolator;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IPhysObjectWorld;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class ShipTransformUpdateMessageHandler
implements IMessageHandler<ShipTransformUpdateMessage, IMessage> {
    public IMessage onMessage(final ShipTransformUpdateMessage message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                IPhysObjectWorld physObjectWorld = ValkyrienUtils.getPhysObjWorld((World)world);
                QueryableShipData worldData = QueryableShipData.get((World)world);
                for (Map.Entry<UUID, Tuple<ShipTransform, AxisAlignedBB>> transformUpdate : message.shipTransforms.entrySet()) {
                    UUID shipID = transformUpdate.getKey();
                    ShipTransform shipTransform = (ShipTransform)transformUpdate.getValue().func_76341_a();
                    AxisAlignedBB shipBB = (AxisAlignedBB)transformUpdate.getValue().func_76340_b();
                    PhysicsObject physicsObject = ValkyrienUtils.getPhysObjWorld((World)world).getPhysObjectFromUUID(shipID);
                    if (physicsObject == null) continue;
                    ITransformInterpolator interpolator = physicsObject.getTransformInterpolator();
                    interpolator.onNewTransformPacket(shipTransform, shipBB);
                }
            }
        });
        return null;
    }
}

