/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonProcessingException;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ObjectMapper;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.util.jackson.VSJacksonUtil;

public class ShipIndexDataMessage
implements IMessage {
    private static final ObjectMapper serializer = VSJacksonUtil.getPacketMapper();
    final List<ShipData> indexedData = new ArrayList<ShipData>();
    final List<UUID> shipsToLoad = new ArrayList<UUID>();
    final List<UUID> shipsToUnload = new ArrayList<UUID>();
    int dimensionID = -1;

    public void addData(Collection<ShipData> toSend) {
        this.indexedData.addAll(toSend);
    }

    public void addLoadUUID(UUID toLoad) {
        this.shipsToLoad.add(toLoad);
    }

    public void addUnloadUUID(UUID toUnload) {
        this.shipsToUnload.add(toUnload);
    }

    public void setDimensionID(int dimensionID) {
        this.dimensionID = dimensionID;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        int numberOfIndices = packetBuffer.readInt();
        int numberOfUUIDLoad = packetBuffer.readInt();
        int numberOfUUIDUnload = packetBuffer.readInt();
        for (i = 0; i < numberOfIndices; ++i) {
            int bytesSize = packetBuffer.readInt();
            byte[] bytes = new byte[bytesSize];
            packetBuffer.readBytes(bytes);
            try {
                ShipData data = serializer.readValue(bytes, ShipData.class);
                this.indexedData.add(data);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < numberOfUUIDLoad; ++i) {
            this.shipsToLoad.add(packetBuffer.func_179253_g());
        }
        for (i = 0; i < numberOfUUIDUnload; ++i) {
            this.shipsToUnload.add(packetBuffer.func_179253_g());
        }
        this.dimensionID = packetBuffer.readInt();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.writeInt(this.indexedData.size());
        packetBuffer.writeInt(this.shipsToLoad.size());
        packetBuffer.writeInt(this.shipsToUnload.size());
        for (ShipData data : this.indexedData) {
            try {
                byte[] dataBytes = serializer.writeValueAsBytes(data);
                int bytesSize = dataBytes.length;
                packetBuffer.writeInt(bytesSize);
                packetBuffer.writeBytes(dataBytes);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        for (UUID toLoad : this.shipsToLoad) {
            packetBuffer.func_179252_a(toLoad);
        }
        for (UUID toUnload : this.shipsToUnload) {
            packetBuffer.func_179252_a(toUnload);
        }
        packetBuffer.writeInt(this.dimensionID);
    }
}

