/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.util.JOML;

public final class PlayerMovementData {
    @Nullable
    private final UUID lastTouchedShipId;
    private final int ticksSinceTouchedLastShip;
    private final int ticksPartOfGround;
    @Nonnull
    private final Vector3dc playerPosInShip;
    @Nonnull
    private final Vector3dc playerLookInShip;
    private final boolean onGround;

    public static PlayerMovementData readData(PacketBuffer packetBuffer) {
        boolean hasLastTouchShipId = packetBuffer.readBoolean();
        UUID lastTouchedShipId = hasLastTouchShipId ? packetBuffer.func_179253_g() : null;
        int ticksSinceTouchedLastShip = packetBuffer.readInt();
        int ticksPartOfGround = packetBuffer.readInt();
        Vector3d playerPosInShip = JOML.readFromByteBuf((ByteBuf)packetBuffer);
        Vector3d playerLookInShip = JOML.readFromByteBuf((ByteBuf)packetBuffer);
        boolean onGround = packetBuffer.readBoolean();
        return new PlayerMovementData(lastTouchedShipId, ticksSinceTouchedLastShip, ticksPartOfGround, playerPosInShip, playerLookInShip, onGround);
    }

    public void writeData(PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(this.lastTouchedShipId != null);
        if (this.lastTouchedShipId != null) {
            packetBuffer.func_179252_a(this.lastTouchedShipId);
        }
        packetBuffer.writeInt(this.ticksSinceTouchedLastShip);
        packetBuffer.writeInt(this.ticksPartOfGround);
        JOML.writeToByteBuf(this.playerPosInShip, (ByteBuf)packetBuffer);
        JOML.writeToByteBuf(this.playerLookInShip, (ByteBuf)packetBuffer);
        packetBuffer.writeBoolean(this.onGround);
    }

    public PlayerMovementData(@Nullable UUID lastTouchedShipId, int ticksSinceTouchedLastShip, int ticksPartOfGround, @Nonnull Vector3dc playerPosInShip, @Nonnull Vector3dc playerLookInShip, boolean onGround) {
        if (playerPosInShip == null) {
            throw new NullPointerException("playerPosInShip is marked non-null but is null");
        }
        if (playerLookInShip == null) {
            throw new NullPointerException("playerLookInShip is marked non-null but is null");
        }
        this.lastTouchedShipId = lastTouchedShipId;
        this.ticksSinceTouchedLastShip = ticksSinceTouchedLastShip;
        this.ticksPartOfGround = ticksPartOfGround;
        this.playerPosInShip = playerPosInShip;
        this.playerLookInShip = playerLookInShip;
        this.onGround = onGround;
    }

    @Nullable
    public UUID getLastTouchedShipId() {
        return this.lastTouchedShipId;
    }

    public int getTicksSinceTouchedLastShip() {
        return this.ticksSinceTouchedLastShip;
    }

    public int getTicksPartOfGround() {
        return this.ticksPartOfGround;
    }

    @Nonnull
    public Vector3dc getPlayerPosInShip() {
        return this.playerPosInShip;
    }

    @Nonnull
    public Vector3dc getPlayerLookInShip() {
        return this.playerLookInShip;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerMovementData)) {
            return false;
        }
        PlayerMovementData other = (PlayerMovementData)o;
        UUID this$lastTouchedShipId = this.getLastTouchedShipId();
        UUID other$lastTouchedShipId = other.getLastTouchedShipId();
        if (this$lastTouchedShipId == null ? other$lastTouchedShipId != null : !((Object)this$lastTouchedShipId).equals(other$lastTouchedShipId)) {
            return false;
        }
        if (this.getTicksSinceTouchedLastShip() != other.getTicksSinceTouchedLastShip()) {
            return false;
        }
        if (this.getTicksPartOfGround() != other.getTicksPartOfGround()) {
            return false;
        }
        Vector3dc this$playerPosInShip = this.getPlayerPosInShip();
        Vector3dc other$playerPosInShip = other.getPlayerPosInShip();
        if (this$playerPosInShip == null ? other$playerPosInShip != null : !this$playerPosInShip.equals(other$playerPosInShip)) {
            return false;
        }
        Vector3dc this$playerLookInShip = this.getPlayerLookInShip();
        Vector3dc other$playerLookInShip = other.getPlayerLookInShip();
        if (this$playerLookInShip == null ? other$playerLookInShip != null : !this$playerLookInShip.equals(other$playerLookInShip)) {
            return false;
        }
        return this.isOnGround() == other.isOnGround();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $lastTouchedShipId = this.getLastTouchedShipId();
        result = result * 59 + ($lastTouchedShipId == null ? 43 : ((Object)$lastTouchedShipId).hashCode());
        result = result * 59 + this.getTicksSinceTouchedLastShip();
        result = result * 59 + this.getTicksPartOfGround();
        Vector3dc $playerPosInShip = this.getPlayerPosInShip();
        result = result * 59 + ($playerPosInShip == null ? 43 : $playerPosInShip.hashCode());
        Vector3dc $playerLookInShip = this.getPlayerLookInShip();
        result = result * 59 + ($playerLookInShip == null ? 43 : $playerLookInShip.hashCode());
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PlayerMovementData(lastTouchedShipId=" + this.getLastTouchedShipId() + ", ticksSinceTouchedLastShip=" + this.getTicksSinceTouchedLastShip() + ", ticksPartOfGround=" + this.getTicksPartOfGround() + ", playerPosInShip=" + this.getPlayerPosInShip() + ", playerLookInShip=" + this.getPlayerLookInShip() + ", onGround=" + this.isOnGround() + ")";
    }
}

