/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.item;

import java.text.DecimalFormat;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.BaseItem;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class ItemShipTracker
extends BaseItem {
    private static final String NBT_DATA_KEY = "vs_tracked_ship_uuid";

    public ItemShipTracker(String name, boolean creativeTab) {
        super(name, creativeTab);
        this.field_77777_bU = 1;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack heldItemStack = player.func_184586_b(hand);
            NBTTagCompound stackTagCompound = heldItemStack.func_77942_o() ? heldItemStack.field_77990_d : new NBTTagCompound();
            Optional<PhysicsObject> shipObjectOptional = ValkyrienUtils.getPhysoManagingBlock(worldIn, pos);
            if (shipObjectOptional.isPresent()) {
                PhysicsObject shipObject = shipObjectOptional.get();
                stackTagCompound.func_74778_a(NBT_DATA_KEY, shipObject.getUuid().toString());
                heldItemStack.func_77982_d(stackTagCompound);
                heldItemStack.func_151001_c(shipObject.getName() + " tracker");
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Now tracking ship %s.", shipObject.getName())));
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            ItemStack heldItemStack = player.func_184586_b(hand);
            NBTTagCompound stackTagCompound = heldItemStack.func_77942_o() ? heldItemStack.field_77990_d : new NBTTagCompound();
            if (stackTagCompound.func_74764_b(NBT_DATA_KEY)) {
                UUID shipUUID = UUID.fromString(stackTagCompound.func_74779_i(NBT_DATA_KEY));
                Optional<ShipData> shipDataOptional = ValkyrienUtils.getQueryableData(worldIn).getShip(shipUUID);
                if (shipDataOptional.isPresent()) {
                    ShipData shipData = shipDataOptional.get();
                    ShipTransform currentTransform = shipData.getShipTransform();
                    Vector3d shipPosition = new Vector3d(currentTransform.getPosX(), currentTransform.getPosY(), currentTransform.getPosZ());
                    String shipPositionString = shipPosition.toString(new DecimalFormat("############.##"));
                    player.func_145747_a((ITextComponent)new TextComponentString(String.format("The ship %s is currently at %s.", shipData.getName(), shipPositionString)));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(String.format("No ship with UUID %s found! Maybe it was destroyed.", shipUUID.toString())));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Not tracking any ships. Right click on a ship to track it."));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }
}

