/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.ships.ShipData;

public final class EntityShipMovementData {
    @Nullable
    private final ShipData lastTouchedShip;
    private final int ticksSinceTouchedShip;
    private final int ticksPartOfGround;
    @Nonnull
    @NonNull
    private final Vector3dc addedLinearVelocity;
    private final double addedYawVelocity;

    public EntityShipMovementData(@Nullable ShipData lastTouchedShip, int ticksSinceTouchedShip, int ticksPartOfGround, @Nonnull @NonNull Vector3dc addedLinearVelocity, double addedYawVelocity) {
        if (addedLinearVelocity == null) {
            throw new NullPointerException("addedLinearVelocity is marked non-null but is null");
        }
        this.lastTouchedShip = lastTouchedShip;
        this.ticksSinceTouchedShip = ticksSinceTouchedShip;
        this.ticksPartOfGround = ticksPartOfGround;
        this.addedLinearVelocity = addedLinearVelocity;
        this.addedYawVelocity = addedYawVelocity;
    }

    @Nullable
    public ShipData getLastTouchedShip() {
        return this.lastTouchedShip;
    }

    public int getTicksSinceTouchedShip() {
        return this.ticksSinceTouchedShip;
    }

    public int getTicksPartOfGround() {
        return this.ticksPartOfGround;
    }

    @Nonnull
    @NonNull
    public Vector3dc getAddedLinearVelocity() {
        return this.addedLinearVelocity;
    }

    public double getAddedYawVelocity() {
        return this.addedYawVelocity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityShipMovementData)) {
            return false;
        }
        EntityShipMovementData other = (EntityShipMovementData)o;
        ShipData this$lastTouchedShip = this.getLastTouchedShip();
        ShipData other$lastTouchedShip = other.getLastTouchedShip();
        if (this$lastTouchedShip == null ? other$lastTouchedShip != null : !this$lastTouchedShip.equals(other$lastTouchedShip)) {
            return false;
        }
        if (this.getTicksSinceTouchedShip() != other.getTicksSinceTouchedShip()) {
            return false;
        }
        if (this.getTicksPartOfGround() != other.getTicksPartOfGround()) {
            return false;
        }
        Vector3dc this$addedLinearVelocity = this.getAddedLinearVelocity();
        Vector3dc other$addedLinearVelocity = other.getAddedLinearVelocity();
        if (this$addedLinearVelocity == null ? other$addedLinearVelocity != null : !this$addedLinearVelocity.equals(other$addedLinearVelocity)) {
            return false;
        }
        return Double.compare(this.getAddedYawVelocity(), other.getAddedYawVelocity()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ShipData $lastTouchedShip = this.getLastTouchedShip();
        result = result * 59 + ($lastTouchedShip == null ? 43 : $lastTouchedShip.hashCode());
        result = result * 59 + this.getTicksSinceTouchedShip();
        result = result * 59 + this.getTicksPartOfGround();
        Vector3dc $addedLinearVelocity = this.getAddedLinearVelocity();
        result = result * 59 + ($addedLinearVelocity == null ? 43 : $addedLinearVelocity.hashCode());
        long $addedYawVelocity = Double.doubleToLongBits(this.getAddedYawVelocity());
        result = result * 59 + (int)($addedYawVelocity >>> 32 ^ $addedYawVelocity);
        return result;
    }

    public String toString() {
        return "EntityShipMovementData(lastTouchedShip=" + this.getLastTouchedShip() + ", ticksSinceTouchedShip=" + this.getTicksSinceTouchedShip() + ", ticksPartOfGround=" + this.getTicksPartOfGround() + ", addedLinearVelocity=" + this.getAddedLinearVelocity() + ", addedYawVelocity=" + this.getAddedYawVelocity() + ")";
    }

    public EntityShipMovementData withLastTouchedShip(@Nullable ShipData lastTouchedShip) {
        return this.lastTouchedShip == lastTouchedShip ? this : new EntityShipMovementData(lastTouchedShip, this.ticksSinceTouchedShip, this.ticksPartOfGround, this.addedLinearVelocity, this.addedYawVelocity);
    }

    public EntityShipMovementData withTicksSinceTouchedShip(int ticksSinceTouchedShip) {
        return this.ticksSinceTouchedShip == ticksSinceTouchedShip ? this : new EntityShipMovementData(this.lastTouchedShip, ticksSinceTouchedShip, this.ticksPartOfGround, this.addedLinearVelocity, this.addedYawVelocity);
    }

    public EntityShipMovementData withTicksPartOfGround(int ticksPartOfGround) {
        return this.ticksPartOfGround == ticksPartOfGround ? this : new EntityShipMovementData(this.lastTouchedShip, this.ticksSinceTouchedShip, ticksPartOfGround, this.addedLinearVelocity, this.addedYawVelocity);
    }

    public EntityShipMovementData withAddedLinearVelocity(@Nonnull @NonNull Vector3dc addedLinearVelocity) {
        if (addedLinearVelocity == null) {
            throw new NullPointerException("addedLinearVelocity is marked non-null but is null");
        }
        return this.addedLinearVelocity == addedLinearVelocity ? this : new EntityShipMovementData(this.lastTouchedShip, this.ticksSinceTouchedShip, this.ticksPartOfGround, addedLinearVelocity, this.addedYawVelocity);
    }

    public EntityShipMovementData withAddedYawVelocity(double addedYawVelocity) {
        return this.addedYawVelocity == addedYawVelocity ? this : new EntityShipMovementData(this.lastTouchedShip, this.ticksSinceTouchedShip, this.ticksPartOfGround, this.addedLinearVelocity, addedYawVelocity);
    }
}

