/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.command.config.ShortName;
import org.valkyrienskies.mod.common.config.VSConfigTemplate;

@Config(modid="valkyrienskies")
public class VSConfig
extends VSConfigTemplate {
    @Config.Name(value="Ship Y Position Minimum")
    public static double shipLowerLimit = -30.0;
    @Config.Name(value="Ship Y Position Maximum")
    public static double shipUpperLimit = 1000.0;
    @Config.Name(value="Enable Gravity")
    public static boolean doGravity = true;
    @Config.Name(value="Enable Physics Blocks")
    public static boolean doPhysicsBlocks = true;
    @Config.Name(value="Render Ship Chunk Debug Outline")
    @Config.Comment(value={"When true all ship chunks will be rendered with a green outline (in debug rendering mode (f3 + b))."})
    public static boolean renderShipChunkClaimsInDebug = false;
    @Config.Name(value="Debug Console Output")
    @Config.Comment(value={"Not recommended unless you've encountered a strange bug, or the developers told you to enable this.", "Default is false."})
    public static boolean showAnnoyingDebugOutput = false;
    @Config.Name(value="Physics Speed Multiplier")
    @Config.Comment(value={"Default is 1 for 100% speed. Lower values cause slow motion physics, higher values cause high speed physics."})
    public static double physSpeedMultiplier = 1.0;
    @Config.Name(value="Target TPS")
    @Config.Comment(value={"Target TPS to run the physics world at"})
    public static double targetTps = 60.0;
    @Config.Name(value="Number of Physics Threads")
    @Config.Comment(value={"The number of threads to use for physics", "recommended to use your cpu's thread count minus 2.", "Cannot be set at runtime."})
    @Config.RequiresMcRestart
    @Config.RangeInt(min=2)
    public static int threadCount = Math.max(2, Runtime.getRuntime().availableProcessors() - 2);
    @Config.Name(value="Max Detected Ship Size")
    @Config.Comment(value={"The largest size ship a physics infuser will attempt to make.", "If a ship is larger than this the infuser will assume it was placed on the ground and give up.", "Default is 15000 blocks."})
    public static int maxDetectedShipSize = 15000;
    @Config.Name(value="Gravity Vector X")
    public static double gravityVecX = 0.0;
    @Config.Name(value="Gravity Vector Y")
    public static double gravityVecY = -9.8;
    @Config.Name(value="Gravity Vector Z")
    public static double gravityVecZ = 0.0;
    @Config.Name(value="Number of Ticks Players Stick to Ships")
    @Config.Comment(value={"If a player touches a ship, then unless they touch another ship (or the ground) they will move along with the ship for this many ticks.", "After this number of ticks passes, the player will no longer move with the ship."})
    @Config.RangeInt(min=1)
    public static int ticksToStickToShip = 20;
    @Config.Name(value="Minecarts on ships")
    @Config.Comment(value={"Enabled minecarts on ships. WARNING: This will derail normal minecarts within a ship's AABB"})
    public static boolean minecartsOnShips = false;
    @Config.Name(value="Chair Recipes")
    @Config.Comment(value={"Enable recipes for captain's chair/passenger's chair"})
    public static boolean chairRecipes = true;
    @Config.Name(value="Warn If No Modules")
    @Config.Comment(value={"Send a warning if no known modules are installed"})
    public static boolean warnNoModules = true;
    @Config.Name(value="Use Vanilla Explosions")
    @Config.Comment(value={"If CUSTOM, vanilla explosions are replaced with a custom implementation which supports ships blocking", "explosion damage and is also faster. May have slightly different semantics for things like TNT cannons"})
    public static ExplosionMode explosionMode = ExplosionMode.CUSTOM;
    @Config.Name(value="Ship Loading Settings")
    @ShortName(value="shipLoadingSettings")
    @Config.Comment(value={"Sets the distance at which ships get loaded/unloaded and watched/unwatched by nearby players.", "These settings must obey the following constraint:", "Player Watch Distance < Ship Load Distance < Ship Load Background Distance <= Player Unwatch Distance < Ship Unload Distance"})
    @Config.LangKey(value="valkyrienskies.general.ship_loading_settings")
    public static final ShipLoadingSettings SHIP_LOADING_SETTINGS = new ShipLoadingSettings();
    @Config.Name(value="Accurate Rain")
    @Config.Comment(value={"Prevents rain from going inside ships. Warning: mildly laggy"})
    public static boolean accurateRain = true;
    @Config.Name(value="Multithreading Settings")
    @ShortName(value="multithreadingSettings")
    @Config.Comment(value={"For advanced users only"})
    public static final MultithreadingSettings MULTITHREADING_SETTINGS = new MultithreadingSettings();
    @Config.Name(value="Ship Spawn Detector Blacklist")
    @Config.Comment(value={"Blocks to not be included when assembling a ship."})
    public static String[] shipSpawnDetectorBlacklist = new String[]{"minecraft:air", "minecraft:dirt", "minecraft:grass", "minecraft:stone", "minecraft:tallgrass", "minecraft:water", "minecraft:flowing_water", "minecraft:sand", "minecraft:sandstone", "minecraft:gravel", "minecraft:ice", "minecraft:snow", "minecraft:snow_layer", "minecraft:lava", "minecraft:flowing_lava", "minecraft:grass_path", "minecraft:bedrock", "minecraft:end_portal_frame", "minecraft:end_portal", "minecraft:end_gateway", "minecraft:portal"};
    @Config.Name(value="Block Mass")
    @Config.Comment(value={"Override the auto generated mass value of blocks.", "The units of mass are kg."})
    public static String[] blockMass = new String[]{"minecraft:grass=1500", "minecraft:obsidian=20000"};

    public static double getTimeSimulatedPerTick() {
        return physSpeedMultiplier / targetTps;
    }

    public static Vector3dc gravity() {
        return new Vector3d(gravityVecX, gravityVecY, gravityVecZ);
    }

    public static void sync() {
        ConfigManager.sync((String)"valkyrienskies", (Config.Type)Config.Type.INSTANCE);
        VSConfig.onSync();
    }

    @Mod.EventBusSubscriber(modid="valkyrienskies")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("valkyrienskies")) {
                VSConfig.sync();
            }
        }
    }

    public static class ShipLoadingSettings {
        @Config.Name(value="Player Watch Ship Distance")
        @Config.Comment(value={"If a player's XZ distance to a ship is less than this, then if aren't already watching it, they will start watching that ship."})
        public double watchDistance = 128.0;
        @Config.Name(value="Ship Load Distance")
        @Config.Comment(value={"If a player's XZ distance to a ship is less than this, then if that ship isn't already loaded in the world, it will be loaded in the world immediately."})
        public double loadDistance = 144.0;
        @Config.Name(value="Ship Load Background Distance")
        @Config.Comment(value={"If a player's XZ distance to a ship is less than this, then if that ship isn't already loaded in the world, it will preload itself using background threads."})
        public double loadBackgroundDistance = 160.0;
        @Config.Name(value="Player Unwatch Ship Distance")
        @Config.Comment(value={"If a player's XZ distance to a ship is greater than this, then if they're current watching it, they will stop watching that ship."})
        public double unwatchDistance = 160.0;
        @Config.Name(value="Ship Unload Distance")
        @Config.Comment(value={"If there are no players within this XZ distance of a ship, then if that ship is currently loaded, it will unload itself."})
        public double unloadDistance = 192.0;
        @Config.Name(value="Permanently loaded")
        @Config.Comment(value={"If ships should be permanently. Warning: may have unforseen consequences"})
        public boolean permanentlyLoaded = false;
    }

    public static class MultithreadingSettings {
        public boolean multithreadCollisionCacheUpdate = true;
    }

    public static enum ExplosionMode {
        VANILLA,
        SLOW_VANILLA,
        CUSTOM;

    }
}

