/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.framework;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.apache.commons.io.output.NullOutputStream;
import org.valkyrienskies.mod.common.command.converters.ShipDataConverter;
import org.valkyrienskies.mod.common.command.converters.Vec3dDataConverter;
import org.valkyrienskies.mod.common.command.converters.WorldConverter;
import org.valkyrienskies.mod.common.command.framework.VSCommandFactory;
import org.valkyrienskies.mod.common.command.framework.VSCommandUtil;
import org.valkyrienskies.mod.common.ships.ShipData;
import picocli.AutoComplete;
import picocli.CommandLine;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VSCommandBase<K>
extends CommandBase {
    private final Class<K> cmdClass;
    private final List<String> aliases;
    private final String name;
    private String usage = null;
    private static final Map<Class, CommandLine.ITypeConverter> pureConverters = new HashMap<Class, CommandLine.ITypeConverter>();

    VSCommandBase(Class<K> cmdClass) {
        if (cmdClass.getAnnotation(CommandLine.Command.class) == null) {
            throw new IllegalArgumentException("Clazz must have the PicoCLI @Command annotation!");
        }
        this.cmdClass = cmdClass;
        this.name = this.cmdClass.getAnnotation(CommandLine.Command.class).name();
        this.aliases = Arrays.asList(this.cmdClass.getAnnotation(CommandLine.Command.class).aliases());
    }

    public String func_71517_b() {
        return this.name;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] splitArgs, @Nullable BlockPos targetPos) {
        VSCommandFactory factory = new VSCommandFactory(sender);
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject(factory.create(this.cmdClass), factory);
        String[] args = VSCommandUtil.toTabCompleteArgs(splitArgs);
        ArrayList<CharSequence> candidates = new ArrayList<CharSequence>();
        AutoComplete.complete(spec, args, args.length - 1, args[args.length - 1].length(), 500, candidates);
        return candidates.stream().distinct().map(CharSequence::toString).map(s -> args[args.length - 1] + s).collect(Collectors.toList());
    }

    public String func_71518_a(ICommandSender sender) {
        if (this.usage == null) {
            VSCommandFactory factory = new VSCommandFactory(sender);
            CommandLine commandLine = new CommandLine(factory.create(this.cmdClass), factory);
            this.usage = commandLine.getUsageMessage().replaceAll("^(Usage: )|\r", "");
        }
        return this.usage;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        VSCommandFactory factory = new VSCommandFactory(sender);
        CommandLine commandLine = new CommandLine(factory.create(this.cmdClass), factory);
        this.registerConverters(commandLine, sender);
        ChatWriter chatOut = new ChatWriter(sender);
        commandLine.setOut(chatOut);
        commandLine.setErr(chatOut);
        args = VSCommandUtil.toProperArgs(args);
        commandLine.execute(args);
    }

    private void registerConverters(CommandLine commandLine, ICommandSender sender) {
        pureConverters.forEach(commandLine::registerConverter);
        commandLine.registerConverter(ShipData.class, new ShipDataConverter(sender));
    }

    static {
        pureConverters.put(World.class, new WorldConverter());
        pureConverters.put(Vec3d.class, new Vec3dDataConverter());
    }

    static class ChatWriter
    extends PrintWriter {
        ICommandSender sender;

        ChatWriter(ICommandSender sender) {
            super((OutputStream)new NullOutputStream());
            this.sender = sender;
        }

        @Override
        public void print(Object object) {
            this.print(object.toString());
        }

        @Override
        public void print(String string) {
            string = string.replace("\r", "");
            this.sender.func_145747_a((ITextComponent)new TextComponentString(string));
        }

        @Override
        public void println(String string) {
            this.print(string);
        }
    }
}

